/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.definition;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.CallDef;
import org.webharvest.definition.CallParamDef;
import org.webharvest.definition.CaseDef;
import org.webharvest.definition.ElementInfo;
import org.webharvest.definition.EmptyDef;
import org.webharvest.definition.ExitDef;
import org.webharvest.definition.FileDef;
import org.webharvest.definition.FunctionDef;
import org.webharvest.definition.HtmlToXmlDef;
import org.webharvest.definition.HttpDef;
import org.webharvest.definition.HttpHeaderDef;
import org.webharvest.definition.HttpParamDef;
import org.webharvest.definition.IElementDef;
import org.webharvest.definition.IncludeDef;
import org.webharvest.definition.LoopDef;
import org.webharvest.definition.RegexpDef;
import org.webharvest.definition.ReturnDef;
import org.webharvest.definition.ScriptDef;
import org.webharvest.definition.TemplateDef;
import org.webharvest.definition.TextDef;
import org.webharvest.definition.TryDef;
import org.webharvest.definition.VarDef;
import org.webharvest.definition.VarDefDef;
import org.webharvest.definition.WebHarvestPluginDef;
import org.webharvest.definition.WhileDef;
import org.webharvest.definition.XPathDef;
import org.webharvest.definition.XQueryDef;
import org.webharvest.definition.XmlNode;
import org.webharvest.definition.XsltDef;
import org.webharvest.exception.ConfigurationException;
import org.webharvest.exception.ErrMsg;
import org.webharvest.exception.PluginException;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.DatabasePlugin;
import org.webharvest.runtime.processors.plugins.FtpPlugin;
import org.webharvest.runtime.processors.plugins.JsonToXmlPlugin;
import org.webharvest.runtime.processors.plugins.MailPlugin;
import org.webharvest.runtime.processors.plugins.TokenizePlugin;
import org.webharvest.runtime.processors.plugins.XmlToJsonPlugin;
import org.webharvest.runtime.processors.plugins.ZipPlugin;
import org.webharvest.utils.ClassLoaderUtil;
import org.webharvest.utils.CommonUtil;

public class DefinitionResolver {
    private static Map<String, ElementInfo> elementInfos = new TreeMap<String, ElementInfo>();
    private static Map<String, String> externalPlugins = new LinkedHashMap<String, String>();
    private static Map<String, Class[]> externalPluginDependaces = new HashMap<String, Class[]>();

    private static void registerPlugin(Class pluginClass, boolean isInternalPlugin) {
        String fullClassName = pluginClass != null ? pluginClass.getName() : "null";
        try {
            Object pluginObj = pluginClass.newInstance();
            if (!(pluginObj instanceof WebHarvestPlugin)) {
                throw new PluginException("Plugin class \"" + fullClassName + "\" does not extend WebHarvestPlugin class!");
            }
            WebHarvestPlugin plugin = (WebHarvestPlugin)pluginObj;
            String pluginName = plugin.getName();
            if (!CommonUtil.isValidXmlIdentifier(pluginName)) {
                throw new PluginException("Plugin class \"" + fullClassName + "\" does not define valid name!");
            }
            if (elementInfos.containsKey(pluginName = pluginName.toLowerCase())) {
                throw new PluginException("Plugin named \"" + pluginName + "\" is already registered!");
            }
            String subtags = plugin.getTagDesc();
            String atts = plugin.getAttributeDesc();
            ElementInfo elementInfo = new ElementInfo(pluginName, pluginClass, isInternalPlugin, WebHarvestPluginDef.class, subtags, atts);
            elementInfo.setPlugin(plugin);
            elementInfos.put(pluginName, elementInfo);
            if (!isInternalPlugin) {
                externalPlugins.put(pluginClass.getName(), pluginName);
            }
            externalPluginDependaces.put(pluginName, plugin.getDependantProcessors());
            Class[] subprocessorClasses = plugin.getDependantProcessors();
            if (subprocessorClasses != null) {
                for (Class subClass : subprocessorClasses) {
                    DefinitionResolver.registerPlugin(subClass, isInternalPlugin);
                }
            }
        }
        catch (Exception e) {
            throw new PluginException("Error instantiating plugin class \"" + fullClassName + "\": " + e.getMessage(), e);
        }
    }

    public static void registerPlugin(Class pluginClass) throws PluginException {
        DefinitionResolver.registerPlugin(pluginClass, false);
    }

    public static void registerPlugin(String fullClassName) throws PluginException {
        Class pluginClass = ClassLoaderUtil.getPluginClass(fullClassName);
        DefinitionResolver.registerPlugin(pluginClass, false);
    }

    public static void unregisterPlugin(Class pluginClass) {
        if (pluginClass != null) {
            DefinitionResolver.unregisterPlugin(pluginClass.getName());
        }
    }

    public static void unregisterPlugin(String className) {
        if (DefinitionResolver.isPluginRegistered(className)) {
            String pluginName = externalPlugins.get(className);
            elementInfos.remove(pluginName);
            externalPlugins.remove(className);
            Class[] dependantClasses = externalPluginDependaces.get(pluginName);
            externalPluginDependaces.remove(pluginName);
            if (dependantClasses != null) {
                for (Class c : dependantClasses) {
                    DefinitionResolver.unregisterPlugin(c);
                }
            }
        }
    }

    public static boolean isPluginRegistered(String className) {
        return externalPlugins.containsKey(className);
    }

    public static boolean isPluginRegistered(Class pluginClass) {
        return pluginClass != null && DefinitionResolver.isPluginRegistered(pluginClass.getName());
    }

    public static Map getExternalPlugins() {
        return externalPlugins;
    }

    public static Map getElementInfos() {
        return elementInfos;
    }

    public static ElementInfo getElementInfo(String name) {
        return elementInfos.get(name);
    }

    public static IElementDef createElementDefinition(XmlNode node) {
        String nodeName = node.getName();
        ElementInfo elementInfo = DefinitionResolver.getElementInfo(nodeName);
        if (elementInfo == null || elementInfo.getDefinitionClass() == null || elementInfo.getDefinitionClass() == BaseElementDef.class) {
            throw new ConfigurationException("Unexpected configuration element: " + nodeName + "!");
        }
        DefinitionResolver.validate(node);
        Class elementClass = elementInfo.getDefinitionClass();
        try {
            Constructor constructor = elementClass.getConstructor(XmlNode.class);
            IElementDef elementDef = (IElementDef)constructor.newInstance(node);
            if (elementDef instanceof WebHarvestPluginDef) {
                WebHarvestPluginDef pluginDef = (WebHarvestPluginDef)elementDef;
                pluginDef.setPluginClass(elementInfo.getPluginClass());
                pluginDef.setPluginName(elementInfo.getName());
            }
            return elementDef;
        }
        catch (Exception e) {
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)e;
            }
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw new ConfigurationException("Cannot create class instance: " + elementClass + "!");
        }
    }

    public static void validate(XmlNode node) {
        if (node == null) {
            return;
        }
        String nodeName = node.getName().toLowerCase();
        ElementInfo elementInfo = DefinitionResolver.getElementInfo(nodeName);
        if (elementInfo == null) {
            return;
        }
        Set tags = elementInfo.getTagsSet();
        Set requiredTags = elementInfo.getRequiredTagsSet();
        boolean areAllTagsAllowed = elementInfo.areAllTagsAllowed();
        Set<String> allTagNameSet = elementInfos.keySet();
        for (String tag : requiredTags) {
            if (node.getElement(tag) != null) continue;
            throw new ConfigurationException(ErrMsg.missingTag(node.getName(), tag));
        }
        Iterator subtagsIterator = node.keySet().iterator();
        while (subtagsIterator.hasNext()) {
            String tagName = ((String)subtagsIterator.next()).toLowerCase();
            if ((areAllTagsAllowed || tags.contains(tagName)) && (!areAllTagsAllowed || allTagNameSet.contains(tagName))) continue;
            throw new ConfigurationException(ErrMsg.invalidTag(node.getName(), tagName));
        }
        Set atts = elementInfo.getAttsSet();
        Set requiredAtts = elementInfo.getRequiredAttsSet();
        for (String att : requiredAtts) {
            if (node.getAttribute(att) != null) continue;
            throw new ConfigurationException(ErrMsg.missingAttribute(node.getName(), att));
        }
        Map attributes = node.getAttributes();
        if (attributes != null) {
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                String attName = ((String)it.next()).toLowerCase();
                if (atts.contains(attName)) continue;
                throw new ConfigurationException(ErrMsg.invalidAttribute(node.getName(), attName));
            }
        }
    }

    static {
        String htmlToXmlAtts = "id,outputtype,advancedxmlescape,usecdata,specialentities,unicodechars,omitunknowntags,treatunknowntagsascontent,omitdeprtags,treatdeprtagsascontent,omitxmldecl,omitcomments,omithtmlenvelope,useemptyelementtags,allowmultiwordattributes,allowhtmlinsideattributes,namespacesaware,hyphenreplacement,prunetags,booleanatts";
        elementInfos.put("config", new ElementInfo("config", BaseElementDef.class, null, "charset,scriptlang,id"));
        elementInfos.put("empty", new ElementInfo("empty", EmptyDef.class, null, "id"));
        elementInfos.put("text", new ElementInfo("text", TextDef.class, null, "id,charset,delimiter"));
        elementInfos.put("file", new ElementInfo("file", FileDef.class, null, "id,!path,action,type,charset,listfilter,listfiles,listdirs,listrecursive"));
        elementInfos.put("var-def", new ElementInfo("var-def", VarDefDef.class, null, "id,!name,overwrite"));
        elementInfos.put("var", new ElementInfo("var", VarDef.class, "", "id,!name"));
        elementInfos.put("http", new ElementInfo("http", HttpDef.class, null, "id,!url,method,multipart,charset,username,password,cookie-policy"));
        elementInfos.put("http-param", new ElementInfo("http-param", HttpParamDef.class, null, "id,!name,isfile,filename,contenttype"));
        elementInfos.put("http-header", new ElementInfo("http-header", HttpHeaderDef.class, null, "id,!name"));
        elementInfos.put("html-to-xml", new ElementInfo("html-to-xml", HtmlToXmlDef.class, null, htmlToXmlAtts));
        elementInfos.put("regexp", new ElementInfo("regexp", RegexpDef.class, "!regexp-pattern,!regexp-source,regexp-result", "id,replace,max,flag-caseinsensitive,flag-multiline,flag-dotall,flag-unicodecase,flag-canoneq"));
        elementInfos.put("regexp-pattern", new ElementInfo("regexp-pattern", BaseElementDef.class, null, "id"));
        elementInfos.put("regexp-source", new ElementInfo("regexp-source", BaseElementDef.class, null, "id"));
        elementInfos.put("regexp-result", new ElementInfo("regexp-result", BaseElementDef.class, null, "id"));
        elementInfos.put("xpath", new ElementInfo("xpath", XPathDef.class, null, "id,!expression"));
        elementInfos.put("xquery", new ElementInfo("xquery", XQueryDef.class, "xq-param,!xq-expression", "id"));
        elementInfos.put("xq-param", new ElementInfo("xq-param", BaseElementDef.class, null, "!name,type,id"));
        elementInfos.put("xq-expression", new ElementInfo("xq-expression", BaseElementDef.class, null, "id"));
        elementInfos.put("xslt", new ElementInfo("xslt", XsltDef.class, "!xml,!stylesheet", "id"));
        elementInfos.put("xml", new ElementInfo("xml", BaseElementDef.class, null, "id"));
        elementInfos.put("stylesheet", new ElementInfo("stylesheet", BaseElementDef.class, null, "id"));
        elementInfos.put("template", new ElementInfo("template", TemplateDef.class, null, "id,language"));
        elementInfos.put("case", new ElementInfo("case", CaseDef.class, "!if,else", "id"));
        elementInfos.put("if", new ElementInfo("if", BaseElementDef.class, null, "!condition,id"));
        elementInfos.put("else", new ElementInfo("else", BaseElementDef.class, null, "id"));
        elementInfos.put("loop", new ElementInfo("loop", LoopDef.class, "!list,!body", "id,item,index,maxloops,filter,empty"));
        elementInfos.put("list", new ElementInfo("list", BaseElementDef.class, null, "id"));
        elementInfos.put("body", new ElementInfo("body", BaseElementDef.class, null, "id"));
        elementInfos.put("while", new ElementInfo("while", WhileDef.class, null, "id,!condition,index,maxloops,empty"));
        elementInfos.put("function", new ElementInfo("function", FunctionDef.class, null, "id,!name"));
        elementInfos.put("return", new ElementInfo("return", ReturnDef.class, null, "id"));
        elementInfos.put("call", new ElementInfo("call", CallDef.class, null, "id,!name"));
        elementInfos.put("call-param", new ElementInfo("call-param", CallParamDef.class, null, "id,!name"));
        elementInfos.put("include", new ElementInfo("include", IncludeDef.class, "", "id,!path"));
        elementInfos.put("try", new ElementInfo("try", TryDef.class, "!body,!catch", "id"));
        elementInfos.put("catch", new ElementInfo("catch", BaseElementDef.class, null, "id"));
        elementInfos.put("script", new ElementInfo("script", ScriptDef.class, null, "id,language,return"));
        elementInfos.put("exit", new ElementInfo("exit", ExitDef.class, "", "id,condition,message"));
        DefinitionResolver.registerPlugin(DatabasePlugin.class, true);
        DefinitionResolver.registerPlugin(JsonToXmlPlugin.class, true);
        DefinitionResolver.registerPlugin(XmlToJsonPlugin.class, true);
        DefinitionResolver.registerPlugin(MailPlugin.class, true);
        DefinitionResolver.registerPlugin(ZipPlugin.class, true);
        DefinitionResolver.registerPlugin(FtpPlugin.class, true);
        DefinitionResolver.registerPlugin(TokenizePlugin.class, true);
    }
}

