/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.PrefixMethodInvocationUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;

public class PrepareInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = -5216969014510719786L;
    private static final Logger LOG = LoggerFactory.getLogger(PrepareInterceptor.class);
    private static final String PREPARE_PREFIX = "prepare";
    private static final String ALT_PREPARE_PREFIX = "prepareDo";
    private boolean alwaysInvokePrepare = true;

    public void setAlwaysInvokePrepare(String alwaysInvokePrepare) {
        this.alwaysInvokePrepare = Boolean.parseBoolean(alwaysInvokePrepare);
    }

    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof Preparable) {
            try {
                PrefixMethodInvocationUtil.invokePrefixMethod(invocation, new String[]{PREPARE_PREFIX, ALT_PREPARE_PREFIX});
            }
            catch (InvocationTargetException e) {
                LOG.warn("an exception occured while trying to execute prefixed method", e, new String[0]);
            }
            catch (IllegalAccessException e) {
                LOG.warn("an exception occured while trying to execute prefixed method", e, new String[0]);
            }
            catch (Exception e) {
                LOG.warn("an exception occured while trying to execute prefixed method", e, new String[0]);
            }
            if (this.alwaysInvokePrepare) {
                ((Preparable)action).prepare();
            }
        }
        return invocation.invoke();
    }
}

