/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.springframework.mock.web.portlet.MockPortletResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MockActionResponse
extends MockPortletResponse
implements ActionResponse {
    private WindowState windowState;
    private PortletMode portletMode;
    private String redirectedUrl;
    private final Map renderParameters = new LinkedHashMap(16);

    public MockActionResponse() {
    }

    public MockActionResponse(PortalContext portalContext) {
        super(portalContext);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set WindowState after sendRedirect has been called");
        }
        if (!CollectionUtils.contains((Enumeration)this.getPortalContext().getSupportedWindowStates(), (Object)windowState)) {
            throw new WindowStateException("WindowState not supported", windowState);
        }
        this.windowState = windowState;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set PortletMode after sendRedirect has been called");
        }
        if (!CollectionUtils.contains((Enumeration)this.getPortalContext().getSupportedPortletModes(), (Object)portletMode)) {
            throw new PortletModeException("PortletMode not supported", portletMode);
        }
        this.portletMode = portletMode;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void sendRedirect(String url) throws IOException {
        if (this.windowState != null || this.portletMode != null || !this.renderParameters.isEmpty()) {
            throw new IllegalStateException("Cannot call sendRedirect after windowState, portletMode, or renderParameters have been set");
        }
        Assert.notNull((Object)url, (String)"Redirect URL must not be null");
        this.redirectedUrl = url;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void setRenderParameters(Map parameters) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set render parameters after sendRedirect has been called");
        }
        Assert.notNull((Object)parameters, (String)"Parameters Map must not be null");
        this.renderParameters.clear();
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Assert.isTrue((boolean)(entry.getKey() instanceof String), (String)"Key must be of type String");
            Assert.isTrue((boolean)(entry.getValue() instanceof String[]), (String)"Value must be of type String[]");
            this.renderParameters.put(entry.getKey(), entry.getValue());
        }
    }

    public void setRenderParameter(String key, String value) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set render parameters after sendRedirect has been called");
        }
        Assert.notNull((Object)key, (String)"Parameter key must not be null");
        Assert.notNull((Object)value, (String)"Parameter value must not be null");
        this.renderParameters.put(key, new String[]{value});
    }

    public String getRenderParameter(String name) {
        String[] arr = (String[])this.renderParameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public void setRenderParameter(String key, String[] values) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set render parameters after sendRedirect has been called");
        }
        Assert.notNull((Object)key, (String)"Parameter key must not be null");
        Assert.notNull((Object)values, (String)"Parameter values must not be null");
        this.renderParameters.put(key, values);
    }

    public String[] getRenderParameterValues(String key) {
        Assert.notNull((Object)key, (String)"Parameter key must not be null");
        return (String[])this.renderParameters.get(key);
    }

    public Iterator getRenderParameterNames() {
        return this.renderParameters.keySet().iterator();
    }

    public Map getRenderParameterMap() {
        return Collections.unmodifiableMap(this.renderParameters);
    }
}

