/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;
import org.h2.command.Parser;
import org.h2.message.Message;
import org.h2.server.web.DbColumn;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.util.New;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbContextRule
implements Rule {
    static final int COLUMN = 0;
    static final int TABLE = 1;
    static final int TABLE_ALIAS = 2;
    static final int NEW_TABLE_ALIAS = 3;
    static final int COLUMN_ALIAS = 4;
    static final int SCHEMA = 5;
    private static final boolean SUGGEST_TABLE_ALIAS = false;
    private DbContents contents;
    private int type;

    DbContextRule(DbContents dbContents, int n) {
        this.contents = dbContents;
        this.type = n;
    }

    public String toString() {
        switch (this.type) {
            case 5: {
                return "schema";
            }
            case 1: {
                return "table";
            }
            case 3: {
                return "nt";
            }
            case 2: {
                return "t";
            }
            case 4: {
                return "c";
            }
            case 0: {
                return "column";
            }
        }
        return "?";
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public String random(Bnf bnf, int n) {
        return null;
    }

    @Override
    public Rule last() {
        return this;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> hashMap) {
    }

    @Override
    public void addNextTokenList(Sentence sentence) {
        switch (this.type) {
            case 5: {
                this.addSchema(sentence);
                break;
            }
            case 1: {
                this.addTable(sentence);
                break;
            }
            case 3: {
                this.addNewTableAlias(sentence);
                break;
            }
            case 2: {
                this.addTableAlias(sentence);
                break;
            }
            case 0: 
            case 4: {
                this.addColumn(sentence);
                break;
            }
        }
    }

    private void addTableAlias(Sentence sentence) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = sentence.getQuery();
        String string2 = StringUtils.toUpperEnglish(string.trim());
        HashMap<String, DbTableOrView> hashMap = sentence.getAliases();
        HashSet hashSet = New.hashSet();
        if (hashMap != null) {
            object4 = hashMap.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                object2 = (String)object3.getKey();
                object = (DbTableOrView)object3.getValue();
                hashSet.add(StringUtils.toUpperEnglish(((DbTableOrView)object).name));
                if (string2.length() != 0 && !((String)object2).startsWith(string2) || string2.length() >= ((String)object2).length()) continue;
                sentence.add((String)object2 + ".", ((String)object2).substring(string2.length()) + ".", 0);
            }
        }
        if ((object4 = sentence.getTables()) != null) {
            object3 = ((HashSet)object4).iterator();
            while (object3.hasNext()) {
                object2 = (DbTableOrView)object3.next();
                object = StringUtils.toUpperEnglish(((DbTableOrView)object2).name);
                if (hashSet.contains(object) || string2.length() != 0 && !((String)object).startsWith(string2) || string2.length() >= ((String)object).length()) continue;
                sentence.add((String)object + ".", ((String)object).substring(string2.length()) + ".", 0);
            }
        }
    }

    private void addNewTableAlias(Sentence sentence) {
    }

    private void addSchema(Sentence sentence) {
        String string = sentence.getQuery();
        String string2 = StringUtils.toUpperEnglish(string);
        if (string2.trim().length() == 0) {
            string2 = string2.trim();
        }
        for (DbSchema dbSchema : this.contents.schemas) {
            if (dbSchema == this.contents.defaultSchema || string2.length() != 0 && !StringUtils.toUpperEnglish(dbSchema.name).startsWith(string2) || string2.length() >= dbSchema.quotedName.length()) continue;
            sentence.add(dbSchema.quotedName + ".", dbSchema.quotedName.substring(string2.length()) + ".", 0);
        }
    }

    private void addTable(Sentence sentence) {
        String string;
        String string2 = sentence.getQuery();
        DbSchema dbSchema = sentence.getLastMatchedSchema();
        if (dbSchema == null) {
            dbSchema = this.contents.defaultSchema;
        }
        if ((string = StringUtils.toUpperEnglish(string2)).trim().length() == 0) {
            string = string.trim();
        }
        for (DbTableOrView dbTableOrView : dbSchema.tables) {
            if (string.length() != 0 && !StringUtils.toUpperEnglish(dbTableOrView.name).startsWith(string) || string.length() >= dbTableOrView.quotedName.length()) continue;
            sentence.add(dbTableOrView.quotedName, dbTableOrView.quotedName.substring(string.length()), 0);
        }
    }

    private void addColumn(Sentence sentence) {
        String string;
        String string2;
        String string3 = string2 = sentence.getQuery();
        String string4 = "";
        if (string2.trim().length() == 0) {
            string3 = null;
        } else {
            string3 = StringUtils.toUpperEnglish(string2.trim());
            if (string3.endsWith(".")) {
                string3 = string3.substring(0, string3.length() - 1);
            } else {
                string4 = StringUtils.toUpperEnglish(string2.trim());
                string3 = null;
            }
        }
        HashSet<DbTableOrView> hashSet = null;
        HashMap<String, DbTableOrView> hashMap = sentence.getAliases();
        if (string3 == null && sentence.getTables() != null) {
            hashSet = sentence.getTables();
        }
        Object object = null;
        if (string3 != null && hashMap != null && hashMap.get(string3) != null) {
            object = hashMap.get(string3);
            string3 = StringUtils.toUpperEnglish(((DbTableOrView)object).name);
        }
        if (string3 == null) {
            if (hashSet == null && hashMap == null) {
                return;
            }
            if (hashSet != null && hashSet.size() > 1 || hashMap != null && hashMap.size() > 1) {
                return;
            }
        }
        if (object == null) {
            for (DbTableOrView object2 : this.contents.defaultSchema.tables) {
                string = StringUtils.toUpperEnglish(object2.name);
                if (string3 != null && !string3.equals(string) || hashSet != null && !hashSet.contains(object2)) continue;
                object = object2;
                break;
            }
        }
        if (object != null && ((DbTableOrView)object).columns != null) {
            for (DbColumn dbColumn : ((DbTableOrView)object).columns) {
                string = dbColumn.name;
                if (!StringUtils.toUpperEnglish(string).startsWith(string4) || string4.length() >= string.length()) continue;
                sentence.add(string, string.substring(string4.length()), 0);
            }
        }
    }

    @Override
    public boolean matchRemove(Sentence sentence) {
        String string;
        if (sentence.getQuery().length() == 0) {
            return false;
        }
        switch (this.type) {
            case 5: {
                string = this.matchSchema(sentence);
                break;
            }
            case 1: {
                string = this.matchTable(sentence);
                break;
            }
            case 3: {
                string = this.matchTableAlias(sentence, true);
                break;
            }
            case 2: {
                string = this.matchTableAlias(sentence, false);
                break;
            }
            case 4: {
                string = this.matchColumnAlias(sentence);
                break;
            }
            case 0: {
                string = this.matchColumn(sentence);
                break;
            }
            default: {
                throw Message.throwInternalError("type=" + this.type);
            }
        }
        if (string == null) {
            return false;
        }
        sentence.setQuery(string);
        return true;
    }

    private String matchSchema(Sentence sentence) {
        String string = sentence.getQuery();
        String string2 = sentence.getQueryUpper();
        DbSchema[] dbSchemaArray = this.contents.schemas;
        String string3 = null;
        DbSchema dbSchema = null;
        for (DbSchema dbSchema2 : dbSchemaArray) {
            String string4 = StringUtils.toUpperEnglish(dbSchema2.name);
            if (!string2.startsWith(string4) || string3 != null && string4.length() <= string3.length()) continue;
            string3 = string4;
            dbSchema = dbSchema2;
        }
        sentence.setLastMatchedSchema(dbSchema);
        if (string3 == null) {
            return null;
        }
        string = string.substring(string3.length());
        return string;
    }

    private String matchTable(Sentence sentence) {
        String string = sentence.getQuery();
        String string2 = sentence.getQueryUpper();
        DbSchema dbSchema = sentence.getLastMatchedSchema();
        if (dbSchema == null) {
            dbSchema = this.contents.defaultSchema;
        }
        DbTableOrView[] dbTableOrViewArray = dbSchema.tables;
        String string3 = null;
        DbTableOrView dbTableOrView = null;
        for (DbTableOrView dbTableOrView2 : dbTableOrViewArray) {
            String string4 = StringUtils.toUpperEnglish(dbTableOrView2.name);
            if (!string2.startsWith(string4) || string3 != null && string4.length() <= string3.length()) continue;
            string3 = string4;
            dbTableOrView = dbTableOrView2;
        }
        if (string3 == null) {
            return null;
        }
        sentence.addTable(dbTableOrView);
        string = string.substring(string3.length());
        return string;
    }

    private String matchColumnAlias(Sentence sentence) {
        char c;
        int n;
        String string = sentence.getQuery();
        String string2 = sentence.getQueryUpper();
        if (string.indexOf(32) < 0) {
            return null;
        }
        for (n = 0; n < string2.length() && ((c = string2.charAt(n)) == '_' || Character.isLetterOrDigit(c)); ++n) {
        }
        if (n == 0) {
            return null;
        }
        String string3 = string2.substring(0, n);
        if (Parser.isKeyword(string3, true)) {
            return null;
        }
        return string.substring(string3.length());
    }

    private String matchTableAlias(Sentence sentence, boolean bl) {
        HashMap<String, DbTableOrView> hashMap;
        char c;
        int n;
        String string = sentence.getQuery();
        String string2 = sentence.getQueryUpper();
        if (string.indexOf(32) < 0) {
            return null;
        }
        for (n = 0; n < string2.length() && ((c = string2.charAt(n)) == '_' || Character.isLetterOrDigit(c)); ++n) {
        }
        if (n == 0) {
            return null;
        }
        String string3 = string2.substring(0, n);
        if (Parser.isKeyword(string3, true)) {
            return null;
        }
        if (bl) {
            sentence.addAlias(string3, sentence.getLastTable());
        }
        if ((hashMap = sentence.getAliases()) != null && hashMap.containsKey(string3) || sentence.getLastTable() == null) {
            if (bl && string.length() == string3.length()) {
                return string;
            }
            string = string.substring(string3.length());
            return string;
        }
        HashSet<DbTableOrView> hashSet = sentence.getTables();
        if (hashSet != null) {
            String string4 = null;
            for (DbTableOrView dbTableOrView : hashSet) {
                String string5 = StringUtils.toUpperEnglish(dbTableOrView.name);
                if (!string3.startsWith(string5) || string4 != null && string5.length() <= string4.length()) continue;
                sentence.setLastMatchedTable(dbTableOrView);
                string4 = string5;
            }
            if (string4 != null) {
                string = string.substring(string4.length());
                return string;
            }
        }
        return null;
    }

    private String matchColumn(Sentence sentence) {
        String string = sentence.getQuery();
        String string2 = sentence.getQueryUpper();
        HashSet<DbTableOrView> hashSet = sentence.getTables();
        String string3 = null;
        DbTableOrView dbTableOrView = sentence.getLastMatchedTable();
        if (dbTableOrView != null && dbTableOrView.columns != null) {
            for (DbColumn object : dbTableOrView.columns) {
                DbColumn[] dbColumnArray = StringUtils.toUpperEnglish(object.name);
                if (!string2.startsWith((String)dbColumnArray)) continue;
                String string4 = string.substring(dbColumnArray.length());
                if (string3 != null && string4.length() >= string3.length()) continue;
                string3 = string4;
            }
        }
        for (DbTableOrView dbTableOrView2 : this.contents.defaultSchema.tables) {
            if (dbTableOrView2 != dbTableOrView && hashSet != null && !hashSet.contains(dbTableOrView2) || dbTableOrView2 == null || dbTableOrView2.columns == null) continue;
            for (DbColumn dbColumn : dbTableOrView2.columns) {
                String string5 = StringUtils.toUpperEnglish(dbColumn.name);
                if (!string2.startsWith(string5)) continue;
                String string6 = string.substring(string5.length());
                if (string3 != null && string6.length() >= string3.length()) continue;
                string3 = string6;
            }
        }
        return string3;
    }

    @Override
    public String getHtmlRailroad(Bnf bnf, boolean bl) {
        return null;
    }
}

