/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.beans.editor.FixedButton;
import com.l2fprod.common.swing.renderer.ColorCellRenderer;
import com.l2fprod.common.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class ColorPropertyEditor
extends AbstractPropertyEditor {
    private ColorCellRenderer label;
    private JButton button;
    private Color color;

    public ColorPropertyEditor() {
        this.editor = new JPanel(new BorderLayout(0, 0));
        this.label = new ColorCellRenderer();
        ((JPanel)this.editor).add("Center", this.label);
        this.label.setOpaque(false);
        this.button = new FixedButton();
        ((JPanel)this.editor).add("East", this.button);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorPropertyEditor.this.selectColor();
            }
        });
        ((JPanel)this.editor).setOpaque(false);
    }

    public Object getValue() {
        return this.color;
    }

    public void setValue(Object value) {
        this.color = (Color)value;
        this.label.setValue(this.color);
    }

    protected void selectColor() {
        ResourceManager rm = ResourceManager.all(FilePropertyEditor.class);
        String title = rm.getString("ColorPropertyEditor.title");
        Color selectedColor = JColorChooser.showDialog(this.editor, title, this.color);
        if (selectedColor != null) {
            Color oldColor = this.color;
            Color newColor = selectedColor;
            this.label.setValue(newColor);
            this.color = newColor;
            this.firePropertyChange(oldColor, newColor);
        }
    }
}

