/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import jaxx.runtime.validator.BeanValidatorEvent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorListener;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwingValidatorMessageListModel
extends AbstractListModel
implements BeanValidatorListener {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(SwingValidatorMessageListModel.class);
    protected transient List<SwingValidator<?>> validators = new ArrayList();
    protected List<SwingValidatorMessage> data = new ArrayList<SwingValidatorMessage>();

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public void registerValidator(SwingValidator<?> validator) {
        if (this.validators.contains(validator)) {
            throw new IllegalArgumentException("the validator " + validator + " is already registred in " + this);
        }
        this.validators.add(validator);
        validator.addBeanValidatorListener(this);
    }

    public void clear() {
        int i = this.data.size();
        if (i > 0) {
            this.data.clear();
            this.fireIntervalRemoved(this, 0, i - 1);
        }
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public Object getElementAt(int index) {
        this.ensureRowIndex(index);
        return this.data.get(index);
    }

    @Override
    public void onFieldChanged(BeanValidatorEvent event) {
        boolean mustDel;
        String[] toDelete = event.getMessagesToDelete();
        String[] toAdd = event.getMessagesToAdd();
        BeanValidatorField<?> field = event.getField();
        BeanValidatorScope scope = event.getScope();
        boolean mustAdd = toAdd != null && toAdd.length > 0;
        boolean bl = mustDel = toDelete != null && toDelete.length > 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)"----------------------------------------------------------");
            log.trace((Object)(field + " - (" + this.getSize() + ") toAdd     " + mustAdd));
            log.trace((Object)(field + " - (" + this.getSize() + ") toDelete  " + mustDel));
        }
        SwingValidator validator = (SwingValidator)event.getSource();
        if (mustDel) {
            this.removeMessages(validator, field, scope, !mustAdd, toDelete);
        }
        if (mustAdd) {
            this.addMessages(validator, field, scope, true, toAdd);
        }
    }

    protected void ensureRowIndex(int index) throws ArrayIndexOutOfBoundsException {
        if (index < -1 || index >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("the rowIndex was " + index + ", but should be int [0," + (this.getSize() - 1) + "]");
        }
    }

    protected void addMessages(SwingValidator<?> validator, BeanValidatorField<?> field, BeanValidatorScope scope, boolean sort, String ... messages) {
        JComponent editor = validator.getFieldRepresentation(field.getName());
        for (String error : messages) {
            SwingValidatorMessage row = new SwingValidatorMessage(validator, field, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireIntervalAdded(this, this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    protected void removeMessages(SwingValidator<?> validator, BeanValidatorField<?> field, BeanValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getSize() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (!error.getValidator().equals(validator) || error.getScope() != scope || !error.getField().equals(field) || !messagesToDel.contains(error.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireIntervalRemoved(this, i, i);
        }
    }
}

