/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ApplicationRunner {
    private static Log log = LogFactory.getLog(ApplicationRunner.class);
    private static final Object lock = new Object();
    private static ApplicationRunner runner;
    protected final String[] args;
    protected boolean reload;
    protected final Runnable runnable;
    protected long startingTime;
    protected Exception error;
    protected Thread mainThread;

    public static ApplicationRunner getRunner() {
        if (runner == null) {
            throw new IllegalStateException("No runner initialized");
        }
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lock() throws InterruptedException {
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlock() {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    protected abstract void initOnce();

    protected abstract void onInit() throws Exception;

    protected abstract void onStart() throws Exception;

    protected abstract void onClose(boolean var1) throws Exception;

    protected abstract void onShutdown() throws Exception;

    protected abstract void onShutdown(Exception var1);

    protected abstract void onError(Exception var1);

    protected ApplicationRunner(String[] args) {
        runner = this;
        this.args = args;
        this.initOnce();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationRunner.this.startingTime = System.nanoTime();
                try {
                    ApplicationRunner.this.onInit();
                    ApplicationRunner.this.onStart();
                }
                catch (Exception e) {
                    ApplicationRunner.this.error = e;
                    ApplicationRunner.this.onError(e);
                    ApplicationRunner.unlock();
                }
            }
        };
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationRunner.this.onShutdown();
                }
                catch (Exception e) {
                    ApplicationRunner.this.error = e;
                    ApplicationRunner.this.onShutdown(e);
                }
            }
        }, "ShutDown " + this.getClass().getSimpleName());
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void launch() {
        this.reload = false;
        this.mainThread = new Thread(this.runnable, this.getClass().getSimpleName());
        this.mainThread.start();
        try {
            ApplicationRunner.lock();
            log.info((Object)("Application [" + this.mainThread + "] is closing..."));
        }
        catch (InterruptedException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(this.mainThread + " was interrupted for reason " + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        boolean reload = this.isReload();
        try {
            this.onClose(reload);
            if (reload) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will reload application");
                }
                System.runFinalization();
                this.launch();
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            if (!reload) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Will shutdown application ...");
                }
                ApplicationRunner.unlock();
                Runtime.getRuntime().exit(0);
            }
        }
    }
}

