/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.log.LutinLog;
import org.nuiton.log.LutinLogEvent;
import org.nuiton.log.LutinLogFactory;
import org.nuiton.log.LutinLogListener;
import org.nuiton.log.LutinProgressEvent;
import org.nuiton.widget.IconFactory;
import org.nuiton.widget.StatusBar;

public class ApplicationMonitor
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int DEFAULT_HEADER_LINE = 100;
    public static int DEFAULT_FOOTER_LINE = 200;
    public static final String DEFAULT_LOGGING_SYSTEM = "";
    public static final String DEFAULT_SMTP_SERVER = "localhost";
    public static final String DEFAULT_FROM_ADDRESS = "applicationMonitor@users.net";
    public static final String DEFAULT_TO_ADDRESS = "cedric";
    protected String loggingSystem;
    protected String smtpServer;
    protected String to;
    protected String from;
    protected PrintStream stdout = null;
    protected PrintStream stderr = null;
    protected LogListener logListener = null;
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    protected JPanel jPanel = null;
    protected JPanel jPanel1 = null;
    protected JButton resetButton = null;
    protected JButton sendByEmailButton = null;
    protected JTabbedPane jTabbedPane = null;
    protected JPanel jPanel2 = null;
    protected JPanel jPanel2bis = null;
    protected JPanel jPanel3 = null;
    protected JScrollPane jScrollPane = null;
    protected JScrollPane jScrollPanebis = null;
    protected JTextArea outputStreamTextArea = null;
    protected JTextArea allStreamsTextArea = null;
    protected JScrollPane jScrollPane1 = null;
    protected JTextArea errorStreamTextArea = null;
    protected StatusBar statusBar = null;
    protected JPanel jPanel4 = null;
    protected JScrollPane jScrollPane2 = null;
    protected JTextArea logStreamTextArea = null;
    protected JPanel jPanel5 = null;
    protected JPanel jPanel6 = null;

    public ApplicationMonitor() {
        this(DEFAULT_LOGGING_SYSTEM);
    }

    public ApplicationMonitor(String loggingSystem) {
        this(loggingSystem, DEFAULT_SMTP_SERVER, DEFAULT_FROM_ADDRESS, DEFAULT_TO_ADDRESS);
    }

    public ApplicationMonitor(String loggingSystem, String smtpServer, String from, String to) {
        this.loggingSystem = loggingSystem;
        this.smtpServer = smtpServer;
        this.from = from;
        this.to = to;
        this.initialize();
    }

    public void resetConsoleContent() {
        this.getAllStreamsTextArea().setText(null);
        this.getOutputStreamTextArea().setText(null);
        this.getErrorStreamTextArea().setText(null);
        this.getLogStreamTextArea().setText(null);
        this.getStatusBar().clearStatus();
    }

    public void sendConsoleContentByMail() {
        try {
            this.send(this.smtpServer, this.to, this.from, I18n._((String)"nuitonwidgets.monitor.mail.subject"), I18n._((String)"nuitonwidgets.monitor.mail.stream.all") + "\n" + this.getAllStreamsTextArea().getText() + "\n\n\n" + I18n._((String)"nuitonwidgets.monitor.mail.stream.output") + "\n" + this.getOutputStreamTextArea().getText() + "\n\n\n" + I18n._((String)"nuitonwidgets.monitor.mail.stream.error") + "\n" + this.getErrorStreamTextArea().getText() + "\n\n\n" + I18n._((String)"nuitonwidgets.monitor.mail.stream.log") + " " + this.loggingSystem + " :\n" + this.getLogStreamTextArea().getText());
            this.getStatusBar().setStatus(I18n._((String)"nuitonwidgets.monitor.mail.report", (Object[])new Object[]{this.to}));
        }
        catch (MessagingException eee) {
            this.getStatusBar().setStatus(I18n._((String)"nuitonwidgets.monitor.mail.failed", (Object[])new Object[]{this.smtpServer}));
        }
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public void setEmailTo(String to) {
        this.to = to;
    }

    public void setEmailFrom(String from) {
        this.from = from;
    }

    protected void initialize() {
        this.initializeUI();
        this.initializeRedirect();
        this.initializeLoggingHandler();
    }

    protected void initializeRedirect() {
        this.stdout = System.out;
        this.stderr = System.err;
        System.setOut(new JTextAreaOutputStream(this.getAllStreamsTextArea(), new JTextAreaOutputStream(this.getOutputStreamTextArea(), this.stdout, true), true));
        System.setErr(new JTextAreaOutputStream(this.getAllStreamsTextArea(), new JTextAreaOutputStream(this.getErrorStreamTextArea(), this.stderr, true), true));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        System.setOut(this.stdout);
        System.setErr(this.stderr);
    }

    protected void initializeLoggingHandler() {
        LogFactory factory = LogFactory.getFactory();
        if (factory instanceof LutinLogFactory) {
            this.logListener = new LogListener();
            ((LutinLogFactory)factory).addLutinLogListener((LutinLogListener)this.logListener);
        } else {
            Logger.getLogger(this.loggingSystem).addHandler(new LoggingHandler());
        }
    }

    protected void send(String smtpServer, String to, String from, String subject, String body) throws AddressException, MessagingException {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(this.byteArrayOutputStream);
            BufferedWriter zipWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            zipOutputStream.putNextEntry(new ZipEntry("report.txt"));
            zipWriter.write(body);
            zipWriter.flush();
            zipOutputStream.closeEntry();
            zipWriter.close();
            Properties props = System.getProperties();
            props.put("mail.smtp.host", smtpServer);
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            msg.setSubject(subject);
            MimeMultipart bodyMime = new MimeMultipart("mixed");
            MimeBodyPart attPart = new MimeBodyPart();
            attPart.setDataHandler(new DataHandler(new DataSource(){

                public String getContentType() {
                    return "application/zip";
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(ApplicationMonitor.this.byteArrayOutputStream.toByteArray());
                }

                public String getName() {
                    return "report.zip";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            }));
            attPart.setDisposition("attachment");
            bodyMime.addBodyPart((BodyPart)attPart);
            msg.setContent((Multipart)bodyMime);
            msg.setHeader("X-Mailer", "Code Lutin Java Mailer");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void initializeUI() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), I18n._((String)"nuitonwidgets.monitor.title"), 0, 0, new Font("Dialog", 1, 12), Color.black));
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 7.0;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 2;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJPanel(), gridBagConstraints1);
        this.add((Component)this.getJPanel1(), gridBagConstraints2);
        this.add((Component)this.getStatusBar(), gridBagConstraints11);
    }

    protected JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.fill = 1;
            this.jPanel.add((Component)this.getJTabbedPane(), gridBagConstraints7);
        }
        return this.jPanel;
    }

    protected JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new Insets(5, 15, 5, 15);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.insets = new Insets(5, 15, 5, 15);
            this.jPanel1.add((Component)this.getResetButton(), gridBagConstraints4);
            this.jPanel1.add((Component)this.getSendByEmailButton(), gridBagConstraints5);
        }
        return this.jPanel1;
    }

    protected JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setText(I18n._((String)"nuitonwidgets.monitor.button.reset"));
            this.resetButton.setIcon(IconFactory.getIcon("RESET"));
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationMonitor.this.resetConsoleContent();
                }
            });
        }
        return this.resetButton;
    }

    protected JButton getSendByEmailButton() {
        if (this.sendByEmailButton == null) {
            this.sendByEmailButton = new JButton();
            this.sendByEmailButton.setText(I18n._((String)"nuitonwidgets.monitor.button.mail"));
            this.sendByEmailButton.setIcon(IconFactory.getIcon("MAIL"));
            this.sendByEmailButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationMonitor.this.sendConsoleContentByMail();
                }
            });
        }
        return this.sendByEmailButton;
    }

    protected JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab(I18n._((String)"nuitonwidgets.monitor.stream.all"), null, this.getJPanel2bis(), null);
            this.jTabbedPane.addTab(I18n._((String)"nuitonwidgets.monitor.stream.output"), null, this.getJPanel2(), null);
            this.jTabbedPane.addTab(I18n._((String)"nuitonwidgets.monitor.stream.error"), null, this.getJPanel3(), null);
            this.jTabbedPane.addTab(I18n._((String)"nuitonwidgets.monitor.stream.log"), null, this.getJPanel4(), null);
            this.jTabbedPane.addTab(I18n._((String)"nuitonwidgets.monitor.information.system"), null, this.getJPanel5(), null);
            this.jTabbedPane.addTab(I18n._((String)"nuitonwidgets.monitor.information.application"), null, this.getJPanel6(), null);
        }
        return this.jTabbedPane;
    }

    protected JPanel getJPanel2bis() {
        if (this.jPanel2bis == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            this.jPanel2bis = new JPanel();
            this.jPanel2bis.setLayout(new GridBagLayout());
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 1;
            this.jPanel2bis.add((Component)this.getJScrollPanebis(), gridBagConstraints8);
        }
        return this.jPanel2bis;
    }

    protected JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 1;
            this.jPanel2.add((Component)this.getJScrollPane(), gridBagConstraints8);
        }
        return this.jPanel2;
    }

    protected JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.fill = 1;
            this.jPanel3.add((Component)this.getJScrollPane1(), gridBagConstraints9);
        }
        return this.jPanel3;
    }

    protected JScrollPane getJScrollPanebis() {
        if (this.jScrollPanebis == null) {
            this.jScrollPanebis = new JScrollPane();
            this.jScrollPanebis.setViewportView(this.getAllStreamsTextArea());
        }
        return this.jScrollPanebis;
    }

    protected JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getOutputStreamTextArea());
        }
        return this.jScrollPane;
    }

    protected JTextArea getAllStreamsTextArea() {
        if (this.allStreamsTextArea == null) {
            this.allStreamsTextArea = new JTextArea();
        }
        return this.allStreamsTextArea;
    }

    protected JTextArea getOutputStreamTextArea() {
        if (this.outputStreamTextArea == null) {
            this.outputStreamTextArea = new JTextArea();
        }
        return this.outputStreamTextArea;
    }

    protected JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getErrorStreamTextArea());
        }
        return this.jScrollPane1;
    }

    protected JTextArea getErrorStreamTextArea() {
        if (this.errorStreamTextArea == null) {
            this.errorStreamTextArea = new JTextArea();
        }
        return this.errorStreamTextArea;
    }

    protected JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.fill = 1;
            this.jPanel4.add((Component)this.getJScrollPane2(), gridBagConstraints12);
        }
        return this.jPanel4;
    }

    protected JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getLogStreamTextArea());
        }
        return this.jScrollPane2;
    }

    protected JTextArea getLogStreamTextArea() {
        if (this.logStreamTextArea == null) {
            this.logStreamTextArea = new JTextArea();
        }
        return this.logStreamTextArea;
    }

    protected JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jPanel5 = new JPanel();
        }
        return this.jPanel5;
    }

    protected JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
        }
        return this.jPanel6;
    }

    protected StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar();
        }
        return this.statusBar;
    }

    protected void ensureLine(JTextArea target) {
        int lineCount = target.getLineCount();
        if (DEFAULT_HEADER_LINE != -1 && DEFAULT_FOOTER_LINE != -1 && lineCount > DEFAULT_HEADER_LINE + DEFAULT_FOOTER_LINE * 2) {
            try {
                int truncatedStart = target.getLineEndOffset(DEFAULT_HEADER_LINE);
                int truncatedEnd = target.getLineStartOffset(lineCount - DEFAULT_FOOTER_LINE);
                target.replaceRange("[...]\n", truncatedStart, truncatedEnd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("org.apache.commons.logging.LogFactory", LutinLogFactory.class.getName());
        I18n.init((String)"fr", (String)"FR");
        JFrame frame = new JFrame();
        ApplicationMonitor am = new ApplicationMonitor();
        frame.setSize(800, 500);
        frame.getContentPane().add(am);
        frame.setDefaultCloseOperation(3);
        System.out.println("Standard output test");
        System.err.println("Standard error test");
        Logger.getLogger(DEFAULT_LOGGING_SYSTEM).log(Level.INFO, "Infomation level logging");
        Logger.getLogger("TODO").log(Level.INFO, "Infomation level logging");
        Log log = LogFactory.getLog(ApplicationMonitor.class);
        System.out.println("Log type: " + log.getClass());
        log.info((Object)"Infomation level logging");
        log.info((Object)"Infomation level logging");
        LutinLog ll = LutinLogFactory.getLutinLog((String)"Une cat\u00e9");
        ll.user((Object)"coucou user");
        frame.setVisible(true);
    }

    protected class LogListener
    implements LutinLogListener {
        protected LogListener() {
        }

        public void logEvent(LutinLogEvent e) {
            StringBuffer trace = new StringBuffer();
            trace.append(DateFormat.getDateTimeInstance().format(new Date(e.getTime())) + " - ");
            trace.append(e.getLogType() + " - ");
            trace.append(e.getMsg() + "\n");
            if (e.getThrowable() != null) {
                trace.append(e.getThrowable().getMessage() + "\n");
                StringWriter stack = new StringWriter();
                PrintWriter print = new PrintWriter(stack);
                e.getThrowable().printStackTrace(print);
                print.close();
                trace.append(stack.getBuffer().toString());
            }
            ApplicationMonitor.this.getAllStreamsTextArea().append(trace.toString());
            ApplicationMonitor.this.ensureLine(ApplicationMonitor.this.getAllStreamsTextArea());
            ApplicationMonitor.this.getLogStreamTextArea().append(trace.toString());
            ApplicationMonitor.this.ensureLine(ApplicationMonitor.this.getLogStreamTextArea());
        }

        public void progressEvent(LutinProgressEvent e) {
        }
    }

    class LoggingHandler
    extends Handler {
        LoggingHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord log) {
            StringBuffer trace = new StringBuffer();
            trace.append(DateFormat.getDateTimeInstance().format(new Date(log.getMillis())) + " - ");
            trace.append(log.getLevel() + " - ");
            trace.append(log.getMessage() + "\n");
            if (log.getThrown() != null) {
                trace.append(log.getThrown().getMessage() + "\n");
                StringWriter stack = new StringWriter();
                PrintWriter print = new PrintWriter(stack);
                log.getThrown().printStackTrace(print);
                print.close();
                trace.append(stack.getBuffer().toString());
            }
            ApplicationMonitor.this.getAllStreamsTextArea().append(trace.toString());
            ApplicationMonitor.this.ensureLine(ApplicationMonitor.this.getAllStreamsTextArea());
            ApplicationMonitor.this.getLogStreamTextArea().append(trace.toString());
            ApplicationMonitor.this.ensureLine(ApplicationMonitor.this.getLogStreamTextArea());
        }
    }

    class JTextAreaOutputStream
    extends PrintStream {
        protected JTextArea target;
        protected PrintStream orig;
        protected boolean showOrig;

        public JTextAreaOutputStream(JTextArea t, PrintStream orig, boolean showOrig) {
            super(new ByteArrayOutputStream());
            this.target = null;
            this.orig = null;
            this.showOrig = false;
            this.target = t;
            this.showOrig = showOrig;
            this.orig = orig;
        }

        @Override
        public void print(boolean b) {
            if (this.showOrig) {
                this.orig.print(b);
            }
            if (b) {
                this.target.append("true");
            } else {
                this.target.append("false");
            }
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(boolean b) {
            if (this.showOrig) {
                this.orig.println(b);
            }
            if (b) {
                this.target.append("true\n");
            } else {
                this.target.append("false\n");
            }
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(char c) {
            if (this.showOrig) {
                this.orig.print(c);
            }
            char[] tmp = new char[]{c};
            this.target.append(new String(tmp));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(char c) {
            if (this.showOrig) {
                this.orig.println(c);
            }
            char[] tmp = new char[]{c, '\n'};
            this.target.append(new String(tmp));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(char[] s) {
            if (this.showOrig) {
                this.orig.print(s);
            }
            this.target.append(new String(s));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(char[] s) {
            if (this.showOrig) {
                this.orig.println(s);
            }
            this.target.append(new String(s) + "\n");
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(double d) {
            if (this.showOrig) {
                this.orig.print(d);
            }
            this.target.append(Double.toString(d));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(double d) {
            if (this.showOrig) {
                this.orig.println(d);
            }
            this.target.append(Double.toString(d) + "\n");
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(float f) {
            if (this.showOrig) {
                this.orig.print(f);
            }
            this.target.append(Float.toString(f));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(float f) {
            if (this.showOrig) {
                this.orig.println(f);
            }
            this.target.append(Float.toString(f) + "\n");
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(int i) {
            if (this.showOrig) {
                this.orig.print(i);
            }
            this.target.append(Integer.toString(i));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(int i) {
            if (this.showOrig) {
                this.orig.println(i);
            }
            this.target.append(Integer.toString(i) + "\n");
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(long l) {
            if (this.showOrig) {
                this.orig.print(l);
            }
            this.target.append(Long.toString(l));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(long l) {
            if (this.showOrig) {
                this.orig.println(l);
            }
            this.target.append(Long.toString(l) + "\n");
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(Object o) {
            if (this.showOrig) {
                this.orig.print(o);
            }
            this.target.append(o.toString());
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(Object o) {
            if (this.showOrig) {
                this.orig.println(o);
            }
            this.target.append(o.toString() + "\n");
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void print(String s) {
            if (this.showOrig) {
                this.orig.print(s);
            }
            this.target.append(s);
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println(String s) {
            if (this.showOrig) {
                this.orig.println(s);
            }
            this.target.append(s + "\n");
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }

        @Override
        public void println() {
            if (this.showOrig) {
                this.orig.println();
            }
            this.target.append(new String("\n"));
            ApplicationMonitor.this.ensureLine(this.target);
            this.target.setCaretPosition(this.target.getText().length());
        }
    }
}

