/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;
import org.jdesktop.jxlayer.plaf.item.LayerItemChangeEvent;
import org.jdesktop.jxlayer.plaf.item.LayerItemListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedLayerUI<V extends JComponent>
extends AbstractBufferedLayerUI<V>
implements LayerItemListener {
    private LayerEffect[] effects = new LayerEffect[0];
    private Shape clip;
    private Composite composite;
    private Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>(0);
    private AffineTransform transform;
    private boolean incrementalUpdate = true;

    @Override
    public void layerItemChanged(LayerItemChangeEvent layerItemChangeEvent) {
        this.setDirty(true);
    }

    public LayerEffect[] getLayerEffects() {
        LayerEffect[] layerEffectArray = new LayerEffect[this.effects.length];
        System.arraycopy(this.effects, 0, layerEffectArray, 0, layerEffectArray.length);
        return layerEffectArray;
    }

    @Override
    protected LayerEffect[] getLayerEffects(JXLayer<V> jXLayer) {
        return this.getLayerEffects();
    }

    public void setLayerEffects(LayerEffect ... layerEffectArray) {
        LayerEffect[] layerEffectArray2 = this.getLayerEffects();
        if (layerEffectArray == null) {
            layerEffectArray = new LayerEffect[]{};
        }
        for (LayerEffect layerEffect : this.getLayerEffects()) {
            layerEffect.removeLayerItemListener(this);
        }
        this.effects = new LayerEffect[layerEffectArray.length];
        System.arraycopy(layerEffectArray, 0, this.effects, 0, layerEffectArray.length);
        for (LayerEffect layerEffect : layerEffectArray) {
            layerEffect.addLayerItemListener(this);
        }
        this.firePropertyChange("layerEffects", layerEffectArray2, layerEffectArray);
        if (!this.isEnabled() || layerEffectArray2.equals(layerEffectArray)) {
            return;
        }
        this.setDirty(true);
    }

    public Shape getClip() {
        return this.clip;
    }

    @Override
    protected Shape getClip(JXLayer<V> jXLayer) {
        return this.getClip();
    }

    public void setClip(Shape shape) {
        Shape shape2 = this.getClip();
        this.clip = shape;
        this.firePropertyChange("clip", shape2, shape);
        if (!this.isEnabled() || shape != null && shape2 != null && shape.equals(shape2)) {
            return;
        }
        this.setDirty(true);
    }

    public Composite getComposite() {
        return this.composite;
    }

    @Override
    protected Composite getComposite(JXLayer<V> jXLayer) {
        return this.getComposite();
    }

    public void setComposite(Composite composite) {
        Composite composite2 = this.getComposite();
        this.composite = composite;
        this.firePropertyChange("composite", composite2, composite);
        if (!this.isEnabled() || composite != null && composite2 != null && composite.equals(composite2)) {
            return;
        }
        this.setDirty(true);
    }

    public float getAlpha() {
        if (this.composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)this.composite;
            return alphaComposite.getAlpha();
        }
        return 1.0f;
    }

    public void setAlpha(float f) {
        float f2 = this.getAlpha();
        this.firePropertyChange("alpha", Float.valueOf(f2), Float.valueOf(f));
        this.setComposite(AlphaComposite.getInstance(3, f));
    }

    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return Collections.unmodifiableMap(this.renderingHints);
    }

    @Override
    protected Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<V> jXLayer) {
        return this.getRenderingHints();
    }

    public void setRenderingHints(Map<RenderingHints.Key, Object> map) {
        Map<RenderingHints.Key, Object> map2 = this.getRenderingHints();
        if (map == null) {
            map = new HashMap<RenderingHints.Key, Object>();
        }
        this.renderingHints = map;
        this.firePropertyChange("renderingHints", map2, map);
        if (!this.isEnabled() || ((Object)map2).equals(map)) {
            return;
        }
        this.setDirty(true);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    protected AffineTransform getTransform(JXLayer<V> jXLayer) {
        return this.getTransform();
    }

    public void setTransform(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform = affineTransform;
        this.firePropertyChange("transform", affineTransform2, affineTransform);
        if (!this.isEnabled() || affineTransform != null && affineTransform2 != null && affineTransform.equals(affineTransform2)) {
            return;
        }
        this.setDirty(true);
    }

    public boolean isIncrementalUpdate() {
        return this.incrementalUpdate;
    }

    @Override
    protected boolean isIncrementalUpdate(JXLayer<V> jXLayer) {
        return this.isIncrementalUpdate();
    }

    public void setIncrementalUpdate(boolean bl) {
        boolean bl2 = this.isIncrementalUpdate();
        this.incrementalUpdate = bl;
        this.firePropertyChange("incrementalUpdate", bl2, bl);
        if (!this.isEnabled() || bl == bl2) {
            return;
        }
        this.setDirty(true);
    }
}

