/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.csv.CSVStrategy;
import org.apache.commons.csv.CharBuffer;
import org.apache.commons.csv.ExtendedBufferedReader;

public class CSVParser {
    private static final int INITIAL_TOKEN_LENGTH = 50;
    protected static final int TT_INVALID = -1;
    protected static final int TT_TOKEN = 0;
    protected static final int TT_EOF = 1;
    protected static final int TT_EORECORD = 2;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final ExtendedBufferedReader in;
    private CSVStrategy strategy;
    private final ArrayList record = new ArrayList();
    private final Token reusableToken = new Token();
    private final CharBuffer wsBuf = new CharBuffer();
    private final CharBuffer code = new CharBuffer(4);

    public CSVParser(InputStream input) {
        this(new InputStreamReader(input));
    }

    public CSVParser(Reader input) {
        this(input, ',');
    }

    public CSVParser(Reader input, char delimiter) {
        this(input, delimiter, '\"', CSVStrategy.COMMENTS_DISABLED);
    }

    public CSVParser(Reader input, char delimiter, char encapsulator, char commentStart) {
        this(input, new CSVStrategy(delimiter, encapsulator, commentStart));
    }

    public CSVParser(Reader input, CSVStrategy strategy) {
        this.in = new ExtendedBufferedReader(input);
        this.strategy = strategy;
    }

    public String[][] getAllValues() throws IOException {
        String[] values;
        ArrayList<String[]> records = new ArrayList<String[]>();
        String[][] ret = null;
        while ((values = this.getLine()) != null) {
            records.add(values);
        }
        if (records.size() > 0) {
            ret = new String[records.size()][];
            records.toArray((T[])ret);
        }
        return ret;
    }

    public String nextValue() throws IOException {
        Token tkn = this.nextToken();
        String ret = null;
        switch (tkn.type) {
            case 0: 
            case 2: {
                ret = tkn.content.toString();
                break;
            }
            case 1: {
                ret = null;
                break;
            }
            default: {
                throw new IOException("(line " + this.getLineNumber() + ") invalid parse sequence");
            }
        }
        return ret;
    }

    public String[] getLine() throws IOException {
        String[] ret = EMPTY_STRING_ARRAY;
        this.record.clear();
        do {
            this.reusableToken.reset();
            this.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case 0: {
                    this.record.add(this.reusableToken.content.toString());
                    break;
                }
                case 2: {
                    this.record.add(this.reusableToken.content.toString());
                    break;
                }
                case 1: {
                    if (this.reusableToken.isReady) {
                        this.record.add(this.reusableToken.content.toString());
                        break;
                    }
                    ret = null;
                    break;
                }
                default: {
                    throw new IOException("(line " + this.getLineNumber() + ") invalid parse sequence");
                }
            }
        } while (this.reusableToken.type == 0);
        if (!this.record.isEmpty()) {
            ret = this.record.toArray(new String[this.record.size()]);
        }
        return ret;
    }

    public int getLineNumber() {
        return this.in.getLineNumber();
    }

    protected Token nextToken() throws IOException {
        return this.nextToken(new Token());
    }

    protected Token nextToken(Token tkn) throws IOException {
        this.wsBuf.clear();
        int lastChar = this.in.readAgain();
        int c = this.in.read();
        boolean eol = this.isEndOfLine(c);
        c = this.in.readAgain();
        while (this.strategy.getIgnoreEmptyLines() && eol && (lastChar == 10 || lastChar == -2) && !this.isEndOfFile(lastChar)) {
            lastChar = c;
            c = this.in.read();
            eol = this.isEndOfLine(c);
            c = this.in.readAgain();
            if (!this.isEndOfFile(c)) continue;
            tkn.type = 1;
            return tkn;
        }
        if (this.isEndOfFile(lastChar) || lastChar != this.strategy.getDelimiter() && this.isEndOfFile(c)) {
            tkn.type = 1;
            return tkn;
        }
        while (!tkn.isReady) {
            while (this.isWhitespace(c) && !eol) {
                this.wsBuf.append((char)c);
                c = this.in.read();
                eol = this.isEndOfLine(c);
            }
            if (c == this.strategy.getCommentStart()) {
                this.in.readLine();
                tkn = this.nextToken(tkn.reset());
                continue;
            }
            if (c == this.strategy.getDelimiter()) {
                tkn.type = 0;
                tkn.isReady = true;
                continue;
            }
            if (eol) {
                tkn.type = 2;
                tkn.isReady = true;
                continue;
            }
            if (c == this.strategy.getEncapsulator()) {
                this.encapsulatedTokenLexer(tkn, c);
                continue;
            }
            if (this.isEndOfFile(c)) {
                tkn.type = 1;
                tkn.isReady = true;
                continue;
            }
            if (!this.strategy.getIgnoreLeadingWhitespaces()) {
                tkn.content.append(this.wsBuf);
            }
            this.simpleTokenLexer(tkn, c);
        }
        return tkn;
    }

    private Token simpleTokenLexer(Token tkn, int c) throws IOException {
        while (true) {
            if (this.isEndOfLine(c)) {
                tkn.type = 2;
                tkn.isReady = true;
                break;
            }
            if (this.isEndOfFile(c)) {
                tkn.type = 1;
                tkn.isReady = true;
                break;
            }
            if (c == this.strategy.getDelimiter()) {
                tkn.type = 0;
                tkn.isReady = true;
                break;
            }
            if (c == 92 && this.strategy.getUnicodeEscapeInterpretation() && this.in.lookAhead() == 117) {
                tkn.content.append((char)this.unicodeEscapeLexer(c));
            } else if (c == this.strategy.getEscape()) {
                tkn.content.append((char)this.readEscape(c));
            } else {
                tkn.content.append((char)c);
            }
            c = this.in.read();
        }
        if (this.strategy.getIgnoreTrailingWhitespaces()) {
            tkn.content.trimTrailingWhitespace();
        }
        return tkn;
    }

    private Token encapsulatedTokenLexer(Token tkn, int c) throws IOException {
        int startLineNumber = this.getLineNumber();
        while (true) {
            if ((c = this.in.read()) == 92 && this.strategy.getUnicodeEscapeInterpretation() && this.in.lookAhead() == 117) {
                tkn.content.append((char)this.unicodeEscapeLexer(c));
                continue;
            }
            if (c == this.strategy.getEscape()) {
                tkn.content.append((char)this.readEscape(c));
                continue;
            }
            if (c == this.strategy.getEncapsulator()) {
                if (this.in.lookAhead() == this.strategy.getEncapsulator()) {
                    c = this.in.read();
                    tkn.content.append((char)c);
                    continue;
                }
                do {
                    if ((c = this.in.read()) == this.strategy.getDelimiter()) {
                        tkn.type = 0;
                        tkn.isReady = true;
                        return tkn;
                    }
                    if (this.isEndOfFile(c)) {
                        tkn.type = 1;
                        tkn.isReady = true;
                        return tkn;
                    }
                    if (!this.isEndOfLine(c)) continue;
                    tkn.type = 2;
                    tkn.isReady = true;
                    return tkn;
                } while (this.isWhitespace(c));
                throw new IOException("(line " + this.getLineNumber() + ") invalid char between encapsulated token end delimiter");
            }
            if (this.isEndOfFile(c)) {
                throw new IOException("(startline " + startLineNumber + ")" + "eof reached before encapsulated token finished");
            }
            tkn.content.append((char)c);
        }
    }

    protected int unicodeEscapeLexer(int c) throws IOException {
        int ret = 0;
        c = this.in.read();
        this.code.clear();
        try {
            for (int i = 0; i < 4; ++i) {
                c = this.in.read();
                if (this.isEndOfFile(c) || this.isEndOfLine(c)) {
                    throw new NumberFormatException("number too short");
                }
                this.code.append((char)c);
            }
            ret = Integer.parseInt(this.code.toString(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("(line " + this.getLineNumber() + ") Wrong unicode escape sequence found '" + this.code.toString() + "'" + e.toString());
        }
        return ret;
    }

    private int readEscape(int c) throws IOException {
        int out;
        c = this.in.read();
        switch (c) {
            case 114: {
                out = 13;
                break;
            }
            case 110: {
                out = 10;
                break;
            }
            case 116: {
                out = 9;
                break;
            }
            case 98: {
                out = 8;
                break;
            }
            case 102: {
                out = 12;
                break;
            }
            default: {
                out = c;
            }
        }
        return out;
    }

    public CSVParser setStrategy(CSVStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CSVStrategy getStrategy() {
        return this.strategy;
    }

    private boolean isWhitespace(int c) {
        return Character.isWhitespace((char)c) && c != this.strategy.getDelimiter();
    }

    private boolean isEndOfLine(int c) throws IOException {
        if (c == 13 && this.in.lookAhead() == 10) {
            c = this.in.read();
        }
        return c == 10;
    }

    private boolean isEndOfFile(int c) {
        return c == -1;
    }

    static class Token {
        int type = -1;
        CharBuffer content = new CharBuffer(50);
        boolean isReady;

        Token() {
        }

        Token reset() {
            this.content.clear();
            this.type = -1;
            this.isReady = false;
            return this;
        }
    }
}

