/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public abstract class GeneralVariable
extends Instruction
implements Binding {
    private static final int ASSIGNABLE = 1;
    private static final int REQUIRED = 4;
    private static final int TUNNEL = 8;
    private byte properties = 0;
    Expression select = null;
    protected int nameCode = -1;
    SequenceType requiredType;
    private int slotNumber;
    private String variableName;
    protected int referenceCount = 10;

    public void init(Expression expression, int n) {
        this.select = expression;
        this.nameCode = n;
        this.adoptChildExpression(expression);
    }

    public void setSelectExpression(Expression expression) {
        this.select = expression;
        this.adoptChildExpression(expression);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void setAssignable(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 1) : (byte)(this.properties & 0xFFFFFFFE);
    }

    public void setRequiredParam(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 4) : (byte)(this.properties & 0xFFFFFFFB);
    }

    public void setTunnel(boolean bl) {
        this.properties = bl ? (byte)(this.properties | 8) : (byte)(this.properties & 0xFFFFFFF7);
    }

    public void setReferenceCount(int n) {
        this.referenceCount = n;
    }

    public final boolean isAssignable() {
        return (this.properties & 1) != 0;
    }

    public int getVariableFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NoNodeTest.getInstance();
    }

    public int getCardinality() {
        return 8192;
    }

    public boolean isGlobal() {
        return false;
    }

    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public final boolean isRequiredParam() {
        return (this.properties & 4) != 0;
    }

    public final boolean isTunnelParam() {
        return (this.properties & 8) != 0;
    }

    public int getInstructionNameCode() {
        return 185;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.select != null) {
            this.select = this.select.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.select);
        }
        this.checkAgainstRequiredType(staticContext);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.select != null) {
            this.select = this.select.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.select);
        }
        return this;
    }

    private void checkAgainstRequiredType(StaticContext staticContext) throws XPathException {
        RoleLocator roleLocator = new RoleLocator(3, this.variableName, 0, null);
        roleLocator.setSourceLocator(this);
        SequenceType sequenceType = this.requiredType;
        if (sequenceType != null && this.select != null) {
            this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, roleLocator, staticContext);
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        this.process(xPathContext);
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        this.evaluateItem(xPathContext);
        return EmptyIterator.getInstance();
    }

    public ValueRepresentation getSelectValue(XPathContext xPathContext) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)"*** No select expression!!");
        }
        if (this.isAssignable()) {
            return ExpressionTool.eagerEvaluate(this.select, xPathContext);
        }
        return ExpressionTool.lazyEvaluate(this.select, xPathContext, this.referenceCount);
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this.select, promotionOffer);
        }
    }

    public Iterator iterateSubExpressions() {
        if (this.select != null) {
            return new MonoIterator(this.select);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "variable " + namePool.getDisplayName(this.nameCode));
        if (this.select != null) {
            this.select.display(n + 1, namePool, printStream);
        }
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }
}

