/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class UUIDCacheClearTest
extends ChannelTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheClear() throws Exception {
        JChannel c1 = null;
        JChannel c2 = null;
        MyReceiver r1 = new MyReceiver();
        MyReceiver r2 = new MyReceiver();
        try {
            int i;
            c1 = this.createChannel(true, 2);
            c1.setReceiver(r1);
            c1.connect("testCacheClear");
            c2 = this.createChannel(c1);
            c2.setReceiver(r2);
            c2.connect("testCacheClear");
            assert (c2.getView().size() == 2) : "view is " + c2.getView();
            Address c1_addr = c1.getAddress();
            Address c2_addr = c2.getAddress();
            c1.send(c2_addr, null, (Serializable)((Object)"one"));
            c2.send(c1_addr, null, (Serializable)((Object)"one"));
            List<Message> c1_list = r1.getList();
            List<Message> c2_list = r2.getList();
            for (i = 0; i < 10 && (c1_list.isEmpty() || c2_list.isEmpty()); ++i) {
                Util.sleep(500L);
            }
            assert (c1_list.size() == 1 && c2_list.size() == 1);
            UUIDCacheClearTest.printCaches(c1, c2);
            System.out.println("clearing the caches");
            UUIDCacheClearTest.clearCache(c1, c2);
            UUIDCacheClearTest.printCaches(c1, c2);
            r1.clear();
            r2.clear();
            c1.send(c2_addr, null, (Serializable)((Object)"two"));
            c2.send(c1_addr, null, (Serializable)((Object)"two"));
            for (i = 0; i < 10 && (c1_list.isEmpty() || c2_list.isEmpty()); ++i) {
                Util.sleep(1000L);
            }
            assert (c1_list.size() == 1 && c2_list.size() == 1);
            Message msg_from_1 = c2_list.get(0);
            Message msg_from_2 = c1_list.get(0);
            assert (msg_from_1.getSrc().equals(c1_addr));
            assert (msg_from_1.getObject().equals("two"));
            assert (msg_from_2.getSrc().equals(c2_addr));
            assert (msg_from_2.getObject().equals("two"));
        }
        catch (Throwable throwable) {
            Util.close(c2, c1);
            throw throwable;
        }
        Util.close(c2, c1);
    }

    private static void clearCache(JChannel ... channels) {
        for (JChannel ch : channels) {
            ch.getProtocolStack().getTransport().clearLogicalAddressCache();
            ch.down(new Event(8, ch.getAddress()));
        }
    }

    private static void printCaches(JChannel ... channels) {
        System.out.println("chaches:\n");
        for (JChannel ch : channels) {
            System.out.println(ch.getAddress() + ":\n" + ch.getProtocolStack().getTransport().printLogicalAddressCache());
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final List<Message> msgs = new ArrayList<Message>(4);

        private MyReceiver() {
        }

        @Override
        public void receive(Message msg) {
            this.msgs.add(msg);
        }

        public void clear() {
            this.msgs.clear();
        }

        public List<Message> getList() {
            return this.msgs;
        }
    }
}

