/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyLabelHelper;
import org.nuiton.wikitty.WikittyLabelImpl;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

public class WikittyLabelUtil {
    private static Log log = LogFactory.getLog(WikittyLabelUtil.class);

    public static void addLabel(WikittyProxy proxy, String wikittyId, String label) {
        Wikitty w = proxy.restore(wikittyId);
        WikittyLabelImpl l = new WikittyLabelImpl(w);
        l.addLabels(label);
        proxy.store(l);
    }

    public static PagedResult<Wikitty> findAllByLabel(WikittyProxy proxy, String label, int firstIndex, int endIndex) {
        WikittyLabelImpl l = new WikittyLabelImpl();
        l.addLabels(label);
        Criteria criteria = Search.query(l.getWikitty()).criteria().setFirstIndex(firstIndex).setEndIndex(endIndex);
        PagedResult<Wikitty> result = proxy.findAllByCriteria(criteria);
        return result;
    }

    public static Wikitty findByLabel(WikittyProxy proxy, String label) {
        WikittyLabelImpl l = new WikittyLabelImpl();
        l.addLabels(label);
        Criteria criteria = Search.query(l.getWikitty()).criteria();
        Wikitty result = proxy.findByCriteria(criteria);
        return result;
    }

    public static Set<String> findAllAppliedLabels(WikittyProxy proxy, String wikittyId) {
        Wikitty w = proxy.restore(wikittyId);
        Set<String> result = WikittyLabelHelper.getLabels(w);
        return result;
    }
}

