/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.models.AdminTreeSelectionModel;
import com.jurismarches.vradi.ui.admin.renderers.AdminCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.datatips.DataTipManager;
import org.nuiton.wikitty.BusinessEntity;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminNavUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTER_TREE_MODEL = "filterTreeModel";
    public static final String PROPERTY_SHOW_IMPORT_EXPORT = "showImportExport";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_IMPORT_PANEL_VISIBLE = "importPanel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminNavUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminNavUI adminNavUI = this;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected javax.swing.JTextField filterField;
    protected org.nuiton.widget.tree.FilterTreeModel filterTreeModel;
    protected javax.swing.JToolBar headerPanel;
    protected javax.swing.JToolBar importPanel;
    protected javax.swing.JTree nav;
    protected javax.swing.JPanel navPanel;
    protected javax.swing.JLabel none;
    protected java.lang.Boolean showImportExport;
    protected javax.swing.JButton sortButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String NONE = "none";
    
    
    // FIXME add doc about this code !!! Useless now, keep it if commenting it created some bug
    //protected boolean contextInitialized = false;
    
    public  AdminNavUI(JAXXContext parentContext, AdminNavigationTreeHelper helper) {
        SwingUtil.initContext(this, parentContext);
        setContextValue(helper);
        // FIXME add doc about this code !!! Useless now, keep it if commenting it created some bug
        //contextInitialized = true;
    $initialize();
    }
    
    public AdminContentUI getCurrentContent() {
        Component visibleComponent = contentLayout.getVisibleComponent(content);
        if (visibleComponent instanceof AdminContentUI) {
            return (AdminContentUI) visibleComponent;
        }
        return null;
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected AdminNavigationTreeHelper getHelper() {
        return getContextValue(AdminNavigationTreeHelper.class);
    }
    
    protected void $afterCompleteSetup() {
    
        SwingUtil.addExpandOnClickListener(nav);
    
        // extended tooltip for hidden content
        DataTipManager.get().register(nav);
    
        VradiDataProvider dataProvider = getHelper().getDataProvider();
    
        // Register decorator
        DecoratorProvider decoratorProvider = VradiContext.get().getDecoratorProvider();
    
        // Attach renderer
        nav.setCellRenderer(new AdminCellRenderer(decoratorProvider, dataProvider));
        nav.setSelectionModel(new AdminTreeSelectionModel(this, getHandler()));
    
        // Register tree
        getHelper().setUI(nav, true);
    
        // Single selection mode
        nav.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    }
    
    /**
     * Update tree filter on filter model and expand all tree.
     */
    protected void updateFilter() {
        String filterString = filterField.getText();
        AdminNavTreeFilter treeFilter = new AdminNavTreeFilter(filterString);
        filterTreeModel.setFilter(treeFilter);
    
        // si le filtre n'est pas vide, on etend completement l'arbre
        if (StringUtils.isNotEmpty(filterString)) {
    
            // expand the tree
            SwingUtil.expandTree(nav);
            //expandAll(nav, new TreePath(nav.getModel().getRoot()));
        }
    }
    
    /*
     * Expand all node in tree.
     *
    protected void expandAll(JTree tree, TreePath parent) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                expandAll(tree, path);
            }
        }
        // Expansion or collapse must be done bottom-up
        tree.expandPath(parent);
    }*/
    
    /**
     * Reset filter (clear filter text).
     */
    public void resetFilter() {
        getFilterField().setText("");
    }
    
    protected void sort() {
        resetFilter();
        nav.setModel(getHelper().createTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminNavUI() {
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().importClientUsersDBCSV(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().exportClientUsersDBCSV(this);
    }

    public void doActionPerformed__on__sortButton(java.awt.event.ActionEvent event) {
        sort();
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        updateFilter();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JTextField getFilterField() {
        return filterField;
    }

    public org.nuiton.widget.tree.FilterTreeModel getFilterTreeModel() {
        return filterTreeModel;
    }

    public javax.swing.JToolBar getHeaderPanel() {
        return headerPanel;
    }

    public javax.swing.JToolBar getImportPanel() {
        return importPanel;
    }

    public javax.swing.JTree getNav() {
        return nav;
    }

    public javax.swing.JPanel getNavPanel() {
        return navPanel;
    }

    public javax.swing.JLabel getNone() {
        return none;
    }

    public java.lang.Boolean getShowImportExport() {
        return showImportExport;
    }

    public javax.swing.JButton getSortButton() {
        return sortButton;
    }

    public java.lang.Boolean isShowImportExport() {
        return showImportExport !=null && showImportExport;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void setFilterTreeModel(org.nuiton.widget.tree.FilterTreeModel newValue) {
        org.nuiton.widget.tree.FilterTreeModel oldValue = this.filterTreeModel;
        this.filterTreeModel = newValue;
        firePropertyChange(PROPERTY_FILTER_TREE_MODEL, oldValue, newValue);
    }

    public void setShowImportExport(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showImportExport;
        this.showImportExport = newValue;
        firePropertyChange(PROPERTY_SHOW_IMPORT_EXPORT, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminNavUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(navPanel, JSplitPane.LEFT);
        add(content, JSplitPane.RIGHT);
    }

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($JPanel0, NONE);
    }

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add(filterField, BorderLayout.CENTER);
        headerPanel.add(sortButton, BorderLayout.EAST);
    }

    protected void addChildrenToImportPanel() {
        if (!allComponentsCreated) {
            return;
        }
        importPanel.add($JButton0);
        importPanel.add($JButton1);
    }

    protected void addChildrenToNavPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navPanel.add($JScrollPane0, BorderLayout.CENTER);
        navPanel.add(importPanel, BorderLayout.SOUTH);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new javax.swing.JTextField());
        
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterTreeModel() {
        $objectMap.put("filterTreeModel", filterTreeModel = new org.nuiton.widget.tree.FilterTreeModel(getHelper().createTreeModel()));
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new javax.swing.JToolBar());
        
        headerPanel.setName("headerPanel");
        headerPanel.setFloatable(false);
        headerPanel.setLayout(new BorderLayout());
        headerPanel.setOpaque(false);
        headerPanel.setBorderPainted(false);
    }

    protected void createImportPanel() {
        $objectMap.put("importPanel", importPanel = new javax.swing.JToolBar());
        
        importPanel.setName("importPanel");
        importPanel.setFloatable(false);
        importPanel.setLayout(new GridLayout(1, 2));
        importPanel.setOpaque(false);
        importPanel.setBorderPainted(false);
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new javax.swing.JTree());
        
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(false);
    }

    protected void createNavPanel() {
        $objectMap.put("navPanel", navPanel = new javax.swing.JPanel());
        
        navPanel.setName("navPanel");
        navPanel.setLayout(new BorderLayout());
    }

    protected void createNone() {
        $objectMap.put("none", none = new javax.swing.JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(_("vradi.email.noSelection"));
    }

    protected void createShowImportExport() {
        $objectMap.put("showImportExport", showImportExport = false);
    }

    protected void createSortButton() {
        $objectMap.put("sortButton", sortButton = new javax.swing.JButton());
        
        sortButton.setName("sortButton");
        sortButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sortButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminNavUI();
        addChildrenToNavPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        addChildrenToHeaderPanel();
        addChildrenToImportPanel();
        addChildrenToContent();
        // inline complete setup of $JPanel0
        $JPanel0.add(none, BorderLayout.CENTER);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        setDividerLocation(200);
        setResizeWeight(0.1);
        $JScrollPane0.setColumnHeaderView(headerPanel);
        nav.setModel(filterTreeModel);
        sortButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("sort"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("import"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("export"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminNavUI", this);
        createContentLayout();
        createFilterTreeModel();
        createShowImportExport();
        createNavPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNav();
        createHeaderPanel();
        createFilterField();
        createSortButton();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = filterField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createImportPanel();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.admin.importCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.admin.exportCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContent();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createNone();
        // inline creation of adminNavUI
        setName("adminNavUI");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        setDividerSize(12);
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMPORT_PANEL_VISIBLE, true ,"showImportExport") {
        
            @Override
            public void processDataBinding() {
                importPanel.setVisible(isShowImportExport());
            }
        });
    }

}