package com.jurismarches.vradi.ui.helpers;

import java.text.DateFormat;
import java.util.*;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.VradiComparators;
import org.apache.commons.lang.StringUtils;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Infogene;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.TreeNodeImpl;

import static org.nuiton.i18n.I18n._;

/**
 * ToolTipHelper.
 *
 * @author schorlet
 * @version $Revision: 857 $ $Date: 2010-05-06 12:03:11 +0200 (jeu., 06 mai 2010) $
 * @since 20 avr. 2010 12:05:07
 */
public class ToolTipHelper {

    private static final Log log = LogFactory.getLog(ToolTipHelper.class);

    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;
    
    public static String getToolTip(List<Form> forms) {
        if (forms == null || forms.isEmpty()) {
            return null;
        }
        
        StringBuffer result = new StringBuffer();
        result.append("<html>");
        
        int size = forms.size();
        for (int i = 0; i < size && i < 15; i++) {
            Form form = forms.get(i);
            result.append("- ").append(form.getObjet()).append("<br/>");
        }
        
        result.append("</html>");
        return result.toString();
    }

    public static String getToolTip(Form form) {
        if (form == null) {
            return null;
        }

        Map<String, Object> fieldValues = new LinkedHashMap<String, Object>();

        // Form.EXT_FORM
        String formFields[] = new String[] {
                Form.FIELD_DATEPUB, Form.FIELD_DATEPEREMPTION};

        for (String fieldName : formFields) {
            fieldValues.put(fieldName, form.getField(Form.EXT_FORM,
                    fieldName));
        }

        // Infogene.EXT_INFOGENE
        String infogeneFields[] = new String[] {
                Infogene.FIELD_ID, Infogene.FIELD_OBJET,
                Infogene.FIELD_ENTITY, Infogene.FIELD_SOURCETEXT,
                Infogene.FIELD_DESCRIPTION};

        for (String fieldName : infogeneFields) {
            fieldValues.put(fieldName, form.getField(Infogene.EXT_INFOGENE,
                    fieldName));
        }

        // others extensions
        Collection<String> extensionNames = form.getExtensionNames();
        for (String extensionName : extensionNames) {

            if (!Form.EXT_FORM.equals(extensionName)
                    && !Infogene.EXT_INFOGENE.equals(extensionName)) {

                Collection<String> fieldNames = form
                        .getExtensionFields(extensionName);

                for (String fieldName : fieldNames) {
                    fieldValues.put(fieldName, form.getField(extensionName,
                            fieldName));
                }
            }
        }

        StringBuffer result = new StringBuffer();
        result.append("<html>");

        for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();

            if (value == null) {
                continue;
            }

            String stringValue = null;
            if (value instanceof Date) {
                stringValue = DateFormat.getDateTimeInstance(DateFormat.SHORT,
                        DateFormat.MEDIUM, Locale.FRANCE).format((Date) value);
            } else {
                stringValue = String.valueOf(value);
                stringValue = StringUtils.replace(stringValue, "\r", "");
                stringValue = StringUtils.replace(stringValue, "\n\n", "\n");
                stringValue = StringUtils.abbreviate(stringValue, TOOLTIP_ELEMENT_MAX_CHAR_NB);
                stringValue = StringUtils.replace(stringValue, "\n", "<br/>");
            }

            result.append("<strong>").append(key).append("</strong>")
                    .append(" : ").append(stringValue).append("<br/>");
        }

        result.append("</html>");
        return result.toString();
    }

    public static String getThesaurusToolTip(Form form) {
        if (form == null) {
            return null;                                                                                        
        }
        Set<String> thesaurusIds = form.getThesaurus();
        if (thesaurusIds == null) {
            return null;
        }
        VradiThesaurusDTO rootThesaurus = VradiContext.getThesaurusInEntryDef();
        List<VradiThesaurusDTO> thesauruss = new ArrayList<VradiThesaurusDTO>();
        for (String id : thesaurusIds) {
            VradiThesaurusDTO thesaurusFind = rootThesaurus.findThesaurus(id);
            if (thesaurusFind != null) {
                thesauruss.add(thesaurusFind);
            } else {
                log.warn("Thesaurus not found : " + id);
            }
        }

        StringBuffer result = new StringBuffer();
        result.append("<html><h3>");

        // Add title
        result.append(_("vradi.email.thesaurusToolTipTitle"));
        result.append("</h3><br/>");

        // Sort
        Collections.sort(thesauruss, VradiComparators.THESAURUS_NAME_PATH_COMPARATOR);

        // Add thesaurus name path
        for (VradiThesaurusDTO thesaurus : thesauruss) {
            result.append("<strong>").append(thesaurus.getNamePath("/")).append("\n</strong>").append("<br/>");
        }

        result.append("</html>");

        return result.toString();
    }
}
