/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.helpers;

import static org.nuiton.i18n.I18n._;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import com.jurismarches.vradi.entities.Client;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.*;

import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.ui.admin.content.AdminGroupUI;

/**
 * @author letellier
 */
public class GroupNavigationTreeHelper extends AdminNavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory
            .getLog(GroupNavigationTreeHelper.class);

    protected NavigationModel<NavigationTreeNode> cachedModel;

    protected boolean datasChanged = false;    

    public GroupNavigationTreeHelper(JAXXContext context) {
        super(VradiContext.getGroupsEntryDef().getName(), context);

        JAXXContextEntryDef<List<Group>> groupsEntryDef = VradiContext.getGroupsEntryDef();
        VradiContext.get().addPropertyChangeListener(groupsEntryDef, groupsEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
        JAXXContextEntryDef<List<Client>> clientsEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(clientsEntryDef, clientsEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
        JAXXContextEntryDef<List<Client>> usersEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(usersEntryDef, usersEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
    }

    @Override
    public NavigationModel createTreeModel() {

        if (cachedModel != null && !datasChanged){
            return cachedModel;
        }

        JAXXContext context = getContext();

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        JAXXContextEntryDef<List<Group>> groupsEntryDef = VradiContext.getGroupsEntryDef();
        List<Group> groups = VradiContext.getGroupsInEntryDef();

        NavigationTreeNode groupsNode = builder.build(rootNode,
                _(groupsEntryDef.getName()),
                groupsEntryDef, "groups", AdminGroupUI.class,
                null);

        for (Group g : groups) {
            builder.addGroup(context, groupsNode, g);
        }

        // save tree model in context
        cachedModel = builder.getModel();
        setModel(context, cachedModel);

        setSelectedNode(context, groupsNode);

        datasChanged = false;

        return cachedModel;
    }

    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        JAXXContext context = getContext();
        List<Group> groups = VradiContext.getGroupsInEntryDef();
        
        Group bean = (Group) node.getBean();
        groups.remove(bean);
        
        return super.removeChildNode(node);
    }
}
