package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SessionsListUI extends javax.swing.JPanel implements jaxx.runtime.swing.navigation.NavigationContentUI<NavigationTreeNode>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SELECTED_SESSION = "selectedSession";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HEADER_PANEL_VISIBLE = "headerPanel.visible";
    public static final String BINDING_SESSION_PARAGRAPH_TEXT = "sessionParagraph.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUzU8TQRSfVloopfIVEMOHIDXxtMXPmEAQBAk0VYgthNiL091JO2S7O87MtsvF+Cf4J+jdi4k3T8aDZw9ejP+CMR68Gt9sy7ZbFtqEHna7b37v937vzXvv/S8UExwtHGHX1bhjSVolWnb98HC3dER0uUmEzimTNkeNXySKokWUNHy7kGixmFPumaZ7ZsOuMtsiVpv3cg4NCnlsElEhREo0G/TQhcjk/eNllzn8hNUXFcb69s/v6Bvj9bsoQi4DdUOQynw3r1YmfTkUpYZEYxCphjMmtsogg1OrDHpTyrZhYiGe4ip5iV6h/hyKM8yBTKLrvafscXj+LpMoSaqYmgeU1Pd3JNJ0u6odOZyKKuZ6hQitxrFBNYdqHk7LEyGobYkcFXJ/hzGPKC7RsCAm3A8xmgCJ7pxBJQivUR0+DWlrB8rUdNks7Lb4khWCDcL3sEVMKIjK3dVEHUqhZT2jwiV8eH+6gEsmWZJoKlDuhod3ppDDvsNAOpvDJWIudZJ7VgUaa8d6IZfU92jwLJXepobNHzlS2haQzYWEb0MEnSdEI/M9zHGZY1bxMxsNqk2ls3md26apABDlSkBy60jBZ32vkU56iBhwLBBXrnOCFf5aeLBbyrjQUWwd7hd6yxd6g0GfTwcyhwnSWhPUavFIEcW4A2a4qeLpoXsGR41xm+oYN0Xonf6bHP/+6efHrZMZS0LsiVBo24qA3mfcZoRLqkIPNwbMkdTMPMFsuYgSjf719sdMiLB88xjEQbxR5a4pd20biwpQxPp/fP4y+eLbJRTdQoOmjY0trPA7KCErHKpgm4bLHq55iobqA/AcUdokipv42IbmQJdXDCzxfIlaBtzOqgtFmAkpgq+klPj6dzz/Ye2kEBEQdvVMeKsYsecoTi2TWsRbN81NErpekkwQx7BbGyNsh0TUe5A1Z1fznrdPZ6rMd9Xjnuuo131Psvr3wDsb6coAnVejgjZn+QI0fRIaHwZ/pVGGeSxhyZYcSVbDOSd7kVahBilQdo606V5ooFPqF6eJS8zLRF6QJdVgOeha9O5k3W5/rieGx+cwLF5Yw01g+A+Pr7NBgAgAAA==";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.SessionsListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected SessionsListUI emailViewUI = this;
    protected javax.swing.JPanel headerPanel;
    protected com.jurismarches.vradi.services.dto.VradiSessionDTO selectedSession;
    protected javax.swing.JTextArea sessionParagraph;
    protected javax.swing.JPanel sessionParagraphPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public EmailNavigationTreeHelper getHelper(){
        EmailNavigationTreeHelper helper = getContextValue(EmailNavigationTreeHelper.class);
        if (helper == null){
            helper = getParentContainer(EmailPopupUI.class).getHelper();
            setContextValue(helper);
        }
        return helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        getHandler().displaySessions(this, getHelper(), node);
    
        // Get session if selected
        Object selected = getHelper().getSelectedBean(this);
        if (selected instanceof VradiSessionDTO){
            setSelectedSession((VradiSessionDTO)selected);
            headerPanel.setVisible(true);
        }
    
        revalidate();
    }
    
    @Override
    public void closeUI(NavigationTreeNode node) throws Exception {
        this.selectedSession = null;
        headerPanel.setVisible(false);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SessionsListUI() {
        $initialize();
    }

    public SessionsListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__sessionParagraph(java.awt.event.FocusEvent event) {
        getHandler().updateSession(getSelectedSession());
    }

    public void doKeyReleased__on__sessionParagraph(java.awt.event.KeyEvent event) {
        getSelectedSession().setParagraph(sessionParagraph.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JPanel getHeaderPanel() {
        return headerPanel;
    }

    public com.jurismarches.vradi.services.dto.VradiSessionDTO getSelectedSession() {
        return selectedSession;
    }

    public javax.swing.JTextArea getSessionParagraph() {
        return sessionParagraph;
    }

    public javax.swing.JPanel getSessionParagraphPanel() {
        return sessionParagraphPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSelectedSession(com.jurismarches.vradi.services.dto.VradiSessionDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiSessionDTO oldValue = this.selectedSession;
        this.selectedSession = newValue;
        firePropertyChange(PROPERTY_SELECTED_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEmailViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(headerPanel, BorderLayout.NORTH);
        add($JScrollPane1, BorderLayout.CENTER);
    }

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add($Table0, BorderLayout.NORTH);
        headerPanel.add(sessionParagraphPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToSessionParagraphPanel() {
        if (!allComponentsCreated) {
            return;
        }
        sessionParagraphPanel.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new javax.swing.JPanel());
        headerPanel.setName("headerPanel");
        headerPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedSession() {
        $objectMap.put("selectedSession", selectedSession = null);
    }

    protected void createSessionParagraph() {
        $objectMap.put("sessionParagraph", sessionParagraph = new javax.swing.JTextArea());
        sessionParagraph.setName("sessionParagraph");
        sessionParagraph.setColumns(15);
        sessionParagraph.setLineWrap(true);
        sessionParagraph.setWrapStyleWord(true);
        sessionParagraph.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__sessionParagraph"));
        sessionParagraph.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sessionParagraph"));
    }

    protected void createSessionParagraphPanel() {
        $objectMap.put("sessionParagraphPanel", sessionParagraphPanel = new javax.swing.JPanel());
        sessionParagraphPanel.setName("sessionParagraphPanel");
        sessionParagraphPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEmailViewUI();
        addChildrenToHeaderPanel();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HidorButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSessionParagraphPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(sessionParagraph);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(content);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $HidorButton0.setHideTip(_("vradi.email.hideSessionParagraph"));
        $HidorButton0.setShowTip(_("vradi.email.showSessionParagraph"));
        $HidorButton0.setTarget(sessionParagraphPanel);
        $HidorButton0.setTargetVisible(false);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("emailViewUI", this);
        createSelectedSession();
        createHeaderPanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.sessionParagraph"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createSessionParagraphPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createSessionParagraph();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createContent();
        // inline creation of emailViewUI
        setName("emailViewUI");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HEADER_PANEL_VISIBLE, true ,"selectedSession") {
        
            @Override
            public void processDataBinding() {
                headerPanel.setVisible(getSelectedSession() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SESSION_PARAGRAPH_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelectedSession() != null) {
                    jaxx.runtime.SwingUtil.setText(sessionParagraph, getSelectedSession().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().removePropertyChangeListener("paragraph", this);
                }
            }
        });
    }

}