package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.editors.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class CurrencyEditor extends com.jurismarches.vradi.ui.editors.VradiEditor<String, CurrencyEditorModel> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM = "currencyComboBox.selectedItem";
    public static final String BINDING_EDITOR_MODEL = "editor.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Vz08TQRTHXysFyg/5FQhGSEBRb1suXIQAUm2EFCTUGGIvTrsTOmR3Z5wfsPVg/BP8E/TuxcSbJ+PBswcvxn/BGA9ejW92+4NqFXTtYbeZee/zvu/Ne7MvPkNGSZg/JGHoSBNo5lNn68b+/p3KIa3qm1RVJROaS4h/qTSkyzDottaVhsvlonXPNdxzee4LHtDghPdyEQaUrntU1SjVGmY7PapK5Uqt7eVQGNmktkR1oz77+iX91H3yPA0QClRnU5k7zaudSU8R0szVMI6RjkjOI8EBypAsOEC9w3Yt7xGldohPH8Jj6CtCryASYRounT3liBH5h0LD8MI9SVx2y2Vos6hhscp959BIpnwiqzWqnCO77xjm0MhGOXkjMWi1HvsIEcF6NWR87lJPw9LfIratX5szHFvleaCj3MZt5qGjjrEQztYuCU4a98bGGq521Dk2jvecHeNXqIxjWbeRlvdotSEEC1bhGzzUMNkRrbnecJNwsSMMNorTbpT2SabKkJEGlzVMl3/trT3cirtq+qeussBo9/vUxIfXn14Vmq00hrEnu5qemAQ8YiG5oFIzG3ok7iOjmZfbJmK5DFlFPRyjaExmuggrNbZRHMYbs+6OdXduE1VDRKbv45u3Uw/en4N0AQY8TtwCsfabkNU1iVXgnhuKtfVI0dBxPz5HrTY8J4/UucHTPL/iEk3mKixwscKrIRZhpksRWkoq2XffJkov15uFSKGwC781bxcjcx96WeCxgEZT1RiYrlM0KBQ1Lm8PRrdRSdn3qGh03mz0nO+WaZYYzXe5MMKaLITGvq5Eyu2/axFo4gygngolQULGoE9C5hu/xB7RxCgW/CdUfFMkhGQjyN26SKqmvzEzdbxqVuKWmSMa792K0XT137kjOA7HUSNsYOPzpEeZtbg9qqhOmq9RtICzm5TTh5wSO0iWl11e+gNh6kyE64kJa4kIWFT8jLhUUpmQMxTf0NTd1NQ/hfUDkPfoNS0JAAA=";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JComboBox currencyComboBox;
    protected jaxx.runtime.swing.editor.NumberEditor editor;
    protected com.jurismarches.vradi.ui.editors.CurrencyEditorModel model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CurrencyEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    public void init() {
        super.init();
        editor.init();
    }
    
    @Override
    void registerValidator() {
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CurrencyEditor() {
        super();
        $initialize();
    }

    public CurrencyEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__currencyComboBox(java.awt.event.ActionEvent event) {
        if(currencyComboBox.getSelectedItem() != null)                    {model.setCurrency(currencyComboBox.getSelectedItem().toString());};
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JComboBox getCurrencyComboBox() {
        return currencyComboBox;
    }

    public jaxx.runtime.swing.editor.NumberEditor getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.editors.CurrencyEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(com.jurismarches.vradi.ui.editors.CurrencyEditorModel newValue) {
        com.jurismarches.vradi.ui.editors.CurrencyEditorModel oldValue = this.model;
        this.model = newValue;
        firePropertyChange(PROPERTY_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editor, BorderLayout.WEST);
        editorContent.add(currencyComboBox, BorderLayout.CENTER);
    }

    protected void createCurrencyComboBox() {
        $objectMap.put("currencyComboBox", currencyComboBox = new javax.swing.JComboBox());
        currencyComboBox.setName("currencyComboBox");
        currencyComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__currencyComboBox"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new jaxx.runtime.swing.editor.NumberEditor());
        editor.setName("editor");
        editor.setProperty("amount");
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new CurrencyEditorModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        editor.setAutoPopup(true);
        editor.setBean(model);
        editor.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setModelType(Float.class);
        editor.setShowPopupButton(true);
        editor.setShowReset(true);
        editor.setUseFloat(true);
        editor.setUseSign(false);
        currencyComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        currencyComboBox.setMinimumSize(new Dimension(0,28));
        currencyComboBox.setModel(new DefaultComboBoxModel(FieldTypeEnum.Currency.values()));
        currencyComboBox.setRenderer(UIHelper.getTranslationListCellRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createEditor();
        createCurrencyComboBox();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("amount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setModel(model.getAmount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("amount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currency", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    currencyComboBox.setSelectedItem(FieldTypeEnum.getCurrency(model.getCurrency()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currency", this);
                }
            }
        });
    }

}