package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestListUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.QueryMakerBean bean;
    protected javax.swing.JPanel content;
    protected javax.swing.JScrollPane contentScroll;
    protected jaxx.runtime.swing.Table header;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RequestListUI $JPanel0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void init() {
        content.setVisible(false);
        content.removeAll();
        content.setAlignmentY(TOP_ALIGNMENT);
        
        if (bean != null && bean.getQueries() != null) {
            for (String query : bean.getQueries()) {
                createRequest(query);
            }
        }
        content.setVisible(true);    
    }
    
    protected void createRequest(final String query) {
        RequestSelectUI requestUI = new RequestSelectUI(RequestListUI.this);
        requestUI.setAlignmentY(TOP_ALIGNMENT);
        
        try {
            requestUI.setBean(new VradiQueryBean(query));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return;
        }
        
        requestUI.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RequestSelectUI query = (RequestSelectUI) evt.getSource();
    
                VradiQueryBean oldValue = (VradiQueryBean) evt.getOldValue();
                VradiQueryBean newValue = (VradiQueryBean) evt.getNewValue();
    
                log.info("Update query from '" + oldValue + "' to '" + newValue + "'");
                bean.removeQueries(oldValue.toString());
    
                if (newValue == null) {
                    // this means remove
                    content.setVisible(false);
                    content.remove(query);
                    content.setVisible(true);
                } else {
                    // this means update
                    bean.addQueries(newValue.toString());
                }
            }
        });
        requestUI.setAlignmentY(Component.TOP_ALIGNMENT);
        content.add(requestUI);
        validate();
    }
    
    protected void showHistory() {
        AdminHandler handler = getContextValue(AdminHandler.class);
        handler.showHistory(bean.getWikittyId());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestListUI() {
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        showHistory();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        createRequest("");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.QueryMakerBean getBean() {
        return bean;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JScrollPane getContentScroll() {
        return contentScroll;
    }

    public jaxx.runtime.swing.Table getHeader() {
        return header;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.QueryMakerBean newValue) {
        com.jurismarches.vradi.entities.QueryMakerBean oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContentScroll() {
        if (!allComponentsCreated) {
            return;
        }
        contentScroll.getViewport().add(content);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createContentScroll() {
        $objectMap.put("contentScroll", contentScroll = new javax.swing.JScrollPane());
        contentScroll.setName("contentScroll");
    }

    protected void createHeader() {
        $objectMap.put("header", header = new jaxx.runtime.swing.Table());
        header.setName("header");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(header);
        add(contentScroll, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToContentScroll();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("history"));
        contentScroll.setColumnHeaderView(header);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createBean();
        createHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminRequest.title"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.history.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminRequest.new"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContentScroll();
        createContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new GridLayout(0,1));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
    }

}