package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.models.ModifThesaurusModel;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_MODIF_MODEL = "modifModel";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_EDIT_ENABLED = "edit.enabled";
    public static final String BINDING_MODIF_VIEWER_MODEL = "modifViewer.model";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusUI adminThesaurusUI = this;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JButton delete;
    protected javax.swing.JButton edit;
    protected com.jurismarches.vradi.models.ModifThesaurusModel modifModel;
    protected javax.swing.JList modifViewer;
    protected java.lang.Boolean modified;
    protected javax.swing.JSplitPane offerList;
    protected javax.swing.JButton save;
    protected java.lang.Boolean selected;
    protected javax.swing.JTree thesaurus;
    protected jaxx.runtime.swing.HBox toolBar;
    protected javax.swing.JButton viewApply;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane1;
    private jaxx.runtime.swing.VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeHelper helper;
    
    
    public  AdminThesaurusUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        setContextValue(new ModifThesaurusModel(this, helper));
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    public void reinit(ThesaurusTreeHelper helper){
        this.helper = helper;
        setContextValue(helper);
    
        modifModel = new ModifThesaurusModel(this, helper);
        modifViewer.setModel(modifModel);
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
    
        SwingUtil.addExpandOnClickListener(thesaurus);
    }
    
    protected ThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, ThesaurusHandler.class);
    }
    
    public ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                setSelected(path != null);
    
                // Clear if no selection
                if (!isSelected()){
                    tree.clearSelection();
                    getHelper().setSelectedNode(AdminThesaurusUI.this, null);
                }
                
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
                    JMenuItem menuAddChild = new JMenuItem();
                    menuAddChild.setText(_("vradi.menu.addChildThesaurus"));
                    menuAddChild.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                            addChildToSelected();
                        }
                    });
                    popup.add(menuAddChild);
                    
                    JMenuItem menuRenameSelected = new JMenuItem();
                    menuRenameSelected.setText(_("vradi.menu.editThesaurusSelected"));
                    menuRenameSelected.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            editSelected();
                        }
                    });
                    popup.add(menuRenameSelected);
    
                    JMenuItem menuDeleteSeleted = new JMenuItem();
                    menuDeleteSeleted.setText(_("vradi.menu.deleteThesaurusSelected"));
                    menuDeleteSeleted.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            deleteSelected();
                        }
                    });
                    popup.add(menuDeleteSeleted);
    
                    JMenuItem menuMoveSeleted = new JMenuItem();
                    menuMoveSeleted.setText(_("vradi.menu.moveThesaurusSelected"));
                    menuMoveSeleted.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            moveSelected();
                        }
                    });
                    popup.add(menuMoveSeleted);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        SwingUtil.addExpandOnClickListener(thesaurus);
        modifViewer.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
    }
    
    protected void addChildToSelected(){
        log.debug("addChildToSelected ");
        // Ajout dun nouveau thesaurus
        setModified(getThesaurusHandler().addChildThesaurusToSelected(this, helper, modifModel));
    }
    protected void editSelected(){
        log.debug("editSelected ");
        // Edition dun thesaurus
        setModified(getThesaurusHandler().editThesaurusSelected(this, helper, modifModel));
    }
    protected void deleteSelected(){
        log.debug("deleteSelected ");
        // Suppression dun thesaurus
        setModified(getThesaurusHandler().deleteThesaurusSelected(this, helper, modifModel));
    }
    protected void moveSelected(){
        log.debug("moveSelected ");
        // Suppression dun thesaurus
        setModified(getThesaurusHandler().moveThesaurus(this, helper, modifModel));
    }
    
    protected void viewApply(){
        java.util.List<VradiThesaurusDTO> concerned = modifModel.getConcernedThesaurus(modifViewer.getSelectedIndices());
        log.info("Find " + concerned.size() + " thesaurus concerned");
        getThesaurusHandler().viewApply(this, concerned);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminThesaurusUI() {
        $initialize();
    }

    public AdminThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        getThesaurusHandler().cancelThesaurus(this, helper, true);setModified(false);
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        addChildToSelected();
    }

    public void doActionPerformed__on__delete(java.awt.event.ActionEvent event) {
        deleteSelected();
    }

    public void doActionPerformed__on__edit(java.awt.event.ActionEvent event) {
        editSelected();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        getThesaurusHandler().saveThesaurus(this, helper, true);setModified(false);
    }

    public void doActionPerformed__on__viewApply(java.awt.event.ActionEvent event) {
        viewApply();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JButton getEdit() {
        return edit;
    }

    public com.jurismarches.vradi.models.ModifThesaurusModel getModifModel() {
        return modifModel;
    }

    public javax.swing.JList getModifViewer() {
        return modifViewer;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JSplitPane getOfferList() {
        return offerList;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public jaxx.runtime.swing.HBox getToolBar() {
        return toolBar;
    }

    public javax.swing.JButton getViewApply() {
        return viewApply;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModifModel(com.jurismarches.vradi.models.ModifThesaurusModel newValue) {
        com.jurismarches.vradi.models.ModifThesaurusModel oldValue = this.modifModel;
        this.modifModel = newValue;
        firePropertyChange(PROPERTY_MODIF_MODEL, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolBar, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(offerList, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(save, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        offerList.add($JScrollPane0, JSplitPane.LEFT);
        offerList.add($Table0, JSplitPane.RIGHT);
    }

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(create);
        toolBar.add(edit);
        toolBar.add(delete);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new javax.swing.JButton());
        delete.setName("delete");
        delete.setText(_("vradi.common.delete"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createEdit() {
        $objectMap.put("edit", edit = new javax.swing.JButton());
        edit.setName("edit");
        edit.setText(_("vradi.common.edit"));
        edit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__edit"));
    }

    protected void createModifModel() {
        $objectMap.put("modifModel", modifModel = getContextValue(ModifThesaurusModel.class));
    }

    protected void createModifViewer() {
        $objectMap.put("modifViewer", modifViewer = new javax.swing.JList());
        modifViewer.setName("modifViewer");
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createOfferList() {
        $objectMap.put("offerList", offerList = new javax.swing.JSplitPane());
        offerList.setName("offerList");
        offerList.setOneTouchExpandable(true);
        offerList.setContinuousLayout(true);
        offerList.setDividerSize(12);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        thesaurus.setName("thesaurus");
        thesaurus.setExpandsSelectedPaths(true);
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(false);
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new jaxx.runtime.swing.HBox());
        toolBar.setName("toolBar");
    }

    protected void createViewApply() {
        $objectMap.put("viewApply", viewApply = new javax.swing.JButton());
        viewApply.setName("viewApply");
        viewApply.setToolTipText(_("vradi.adminThesaurus.view"));
        viewApply.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__viewApply"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminThesaurusUI();
        addChildrenToToolBar();
        addChildrenToOfferList();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($VBox0, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(modifViewer);
        // inline complete setup of $VBox0
        $VBox0.add(viewApply);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        create.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        edit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        delete.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        offerList.setDividerLocation(300);
        offerList.setOrientation(JSplitPane.VERTICAL_SPLIT);
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
        viewApply.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("view"));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 4 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminThesaurusUI", this);
        createModified();
        createSelected();
        createModifModel();
        createToolBar();
        createCreate();
        createEdit();
        createDelete();
        createOfferList();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.thesaurus.modifTitle"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createModifViewer();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        $VBox0.setName("$VBox0");
        createViewApply();
        createCancel();
        createSave();
        // inline creation of adminThesaurusUI
        setName("adminThesaurusUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                edit.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MODIF_VIEWER_MODEL, true ,"modifModel") {
        
            @Override
            public void processDataBinding() {
                modifViewer.setModel(getModifModel());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified());
            }
        });
    }

}