package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.content.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GROUP_NAME_TEXT = "groupName.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.services.dto.VradiGroupDTO bean;
    protected jaxx.runtime.swing.ListSelectorUI< Client > groupClients;
    protected javax.swing.JTextField groupName;
    protected jaxx.runtime.swing.ListSelectorUI< User > groupUsers;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiGroupDTO > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminGroupUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        addPCSLogger();
        addBeanPCSLogger(bean);
        addBeanModifiedPCS(bean);
        groupClients.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from clients");
                    setModified(true);
                }
            }
        });
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
        requestListUI.init();
    
        java.util.List<Client> toClientCombo = getHandler().getAllClients(this);
        java.util.List<Client> toClientList = new java.util.ArrayList<Client>(toClientCombo);
    
        for (java.util.Iterator<Client> it = toClientList.iterator(); it.hasNext();) {
            Client client = it.next();
            if (bean.getClient() == null || !bean.getClient().contains(client.getWikittyId())) {
                it.remove();
                if (log.isDebugEnabled()) {
                    log.debug("group does NOT use client " + client.getName());
                }
            } else {
                toClientCombo.remove(client);
                if (log.isDebugEnabled()) {
                    log.debug("group use client " + client.getName());
                }
            }
        }
        groupClients.init(toClientCombo, toClientList);
    
        java.util.List<User> toUserCombo = getHandler().getAllUsers(this);
        java.util.List<User> toUserList = new java.util.ArrayList<User>(toUserCombo);
    
        for (java.util.Iterator<User> it = toUserList.iterator(); it.hasNext();) {
            User user = it.next();
            if (bean.getUser() == null || !bean.getUser().contains(user.getWikittyId())) {
                it.remove();
                if (log.isDebugEnabled()) {
                    log.debug("group does NOT use user " + user.getName());
                }
            } else {
                toUserCombo.remove(user);
                if (log.isDebugEnabled()) {
                    log.debug("group use user " + user.getName());
                }
            }
        }
        groupUsers.init(toUserCombo, toUserList);
        
        lastModified.removeAll();
        if(bean != null && bean.getLastModified() != null && bean.getLastModifier() != null) {
            String labelText = String.format(_("vradi.entity.lastModified.date.user"), bean.getLastModified(), bean.getLastModifier());
            lastModified.add(new JLabel(labelText));
        }
    }
    
    @Override
    public void save() {
        if (log.isDebugEnabled()) {
            log.debug("===================================================================================");
            log.debug("group to save " + bean.getName());
        }
        bean.clearClient();
        for (Client client : groupClients.getListDatas()) {
            if (log.isDebugEnabled()) {
                log.debug("add client " + client.getName() + " to group");
            }
            bean.addClient(client.getWikittyId());
        }
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            if (log.isDebugEnabled()) {
                log.debug("add user " + user.getName() + " to group");
            }
            bean.addUser(user.getWikittyId());
        }
    
        this.bean.setLastModified(new java.util.Date());
        this.bean.setLastModifier(getContextValue(VradiUser.class).getName());
        Group bean = (Group) getHelper().getSelectedBean(this);
        if(!bean.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            bean.addExtension(ModificationTag.MODIFICATION_TAG);
        }
        this.bean.toWikitty(bean);
        getHandler().save(bean);
        getHelper().reloadGroup(this, getHelper().getSelectedNode(this), bean);
        groupClients.setModified(false);
        groupUsers.setModified(false);
        if (log.isDebugEnabled()) {
            log.debug("===================================================================================");
        }
    }
    
    @Override
    protected void updateBeanFromEntity(Group bean) {
        this.bean.fromWikitty(bean);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminGroup.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiGroupDTO > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this, getHelper());setModified(true);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), bean);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        bean.setName(groupName.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.services.dto.VradiGroupDTO getBean() {
        return bean;
    }

    public jaxx.runtime.swing.ListSelectorUI< Client > getGroupClients() {
        return groupClients;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public jaxx.runtime.swing.ListSelectorUI< User > getGroupUsers() {
        return groupUsers;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(SwingUtil.boxComponentWithJxLayer(groupName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupClients, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.NORTH);
        body.add(requestListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setFieldRepresentation("name", groupName);
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.services.dto.VradiGroupDTO());
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createGroupClients() {
        $objectMap.put("groupClients", groupClients = new jaxx.runtime.swing.ListSelectorUI< Client >());
        groupClients.setName("groupClients");
        groupClients.setShowHidor(true);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupClients.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< User >());
        groupUsers.setName("groupUsers");
        groupUsers.setShowHidor(true);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        requestListUI.setName("requestListUI");
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.services.dto.VradiGroupDTO >(com.jurismarches.vradi.services.dto.VradiGroupDTO.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.add"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.delete"));
        $HidorButton0.setHideTip(_("vradi.adminGroup.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminGroup.showForm"));
        $HidorButton0.setTarget(adminGroupForm);
        $HidorButton0.setTargetVisible(true);
        groupClients.setAddToComboTip(_("vradi.adminGroup.removeClient"));
        groupClients.setAddToListTip(_("vradi.adminGroup.addClient"));
        groupClients.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeGroup"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel0.setFont(new Font("Serif", Font.BOLD, 26));
        $JLabel0.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 6 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createValidator();
        createBean();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminGroup.createGroup"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        $HidorButton0.setName("$HidorButton0");
        createAdminGroupForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminGroup.listClients"));
        createGroupClients();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("wikittyId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    setEnabled(bean.getWikittyId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("wikittyId", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    $JLabel0.setText(_(updateTitle(bean.getName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GROUP_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, bean.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}