package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Locale;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class VradiMainUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.VradiMainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected VradiMainUI mainFrame = this;
    protected javax.swing.JMenuBar menu;
    protected javax.swing.JMenu menuAdmin;
    protected javax.swing.JMenuItem menuAdminClient;
    protected javax.swing.JMenuItem menuAdminForm;
    protected javax.swing.JMenuItem menuAdminGroup;
    protected javax.swing.JMenuItem menuAdminStatus;
    protected javax.swing.JMenuItem menuAdminThesaurus;
    protected javax.swing.JMenuItem menuAdminXmlStream;
    protected javax.swing.JMenu menuEmail;
    protected javax.swing.JMenuItem menuEmailByClient;
    protected javax.swing.JMenuItem menuEmailByForm;
    protected javax.swing.JMenuItem menuExport;
    protected javax.swing.JMenu menuFile;
    protected javax.swing.JMenuItem menuFileConfiguration;
    protected javax.swing.JMenuItem menuFileExit;
    protected javax.swing.JMenuItem menuFileFullscreen;
    protected javax.swing.JMenu menuFileLanguage;
    protected javax.swing.JMenuItem menuFileLanguageFR;
    protected javax.swing.JMenuItem menuFileLanguageUK;
    protected javax.swing.JMenuItem menuFileNormalscreen;
    protected javax.swing.JMenu menuForm;
    protected javax.swing.JMenu menuHelp;
    protected javax.swing.JMenuItem menuHelpAbout;
    protected javax.swing.JMenuItem menuHelpHelp;
    protected javax.swing.JMenuItem menuHelpSite;
    protected javax.swing.JMenuItem menuImport;
    protected javax.swing.JMenu menuImportExport;
    protected jaxx.runtime.swing.StatusMessagePanel status;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public com.jurismarches.vradi.VradiConfig getConfig() {
        return getContextValue(com.jurismarches.vradi.VradiConfig.class);
    }
    
    public VradiMainUIHandler getHandler() {
        return getContextValue(VradiMainUIHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public boolean acceptLocale(Locale l, String expected) {
      return l != null && l.toString().equals(expected);
    }
    
    void $afterCompleteSetup() {    
        //getBroker().setHandler(getHandler());
        updateFormMenu();
    }
    
    // TODO : Use model
    public void updateFormMenu(){
        getHandler().createFormMenu(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiMainUI() {
        $initialize();
    }

    public VradiMainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuAdminClient(java.awt.event.ActionEvent event) {
        getHandler().showAdminClient(this);
    }

    public void doActionPerformed__on__menuAdminForm(java.awt.event.ActionEvent event) {
        getHandler().showAdminForm(this);
    }

    public void doActionPerformed__on__menuAdminGroup(java.awt.event.ActionEvent event) {
        getHandler().showAdminGroup(this);
    }

    public void doActionPerformed__on__menuAdminStatus(java.awt.event.ActionEvent event) {
        getHandler().showAdminStatus(this);
    }

    public void doActionPerformed__on__menuAdminThesaurus(java.awt.event.ActionEvent event) {
        getHandler().showAdminThesaurus(this);
    }

    public void doActionPerformed__on__menuAdminXmlStream(java.awt.event.ActionEvent event) {
        getHandler().showAdminXmlStream(this);
    }

    public void doActionPerformed__on__menuEmailByClient(java.awt.event.ActionEvent event) {
        getHandler().showEmailByClient(this);
    }

    public void doActionPerformed__on__menuEmailByForm(java.awt.event.ActionEvent event) {
        getHandler().showEmailByForm(this);
    }

    public void doActionPerformed__on__menuExport(java.awt.event.ActionEvent event) {
        getHandler().showExport(this);
    }

    public void doActionPerformed__on__menuFileConfiguration(java.awt.event.ActionEvent event) {
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(java.awt.event.ActionEvent event) {
        getHandler().close(mainFrame);
    }

    public void doActionPerformed__on__menuFileFullscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(java.awt.event.ActionEvent event) {
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(java.awt.event.ActionEvent event) {
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(java.awt.event.ActionEvent event) {
        getHandler().gotoSite(this);
    }

    public void doActionPerformed__on__menuImport(java.awt.event.ActionEvent event) {
        getHandler().showImport(this);
    }

    public void doWindowClosing__on__mainFrame(java.awt.event.WindowEvent event) {
        getHandler().close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JMenuBar getMenu() {
        return menu;
    }

    public javax.swing.JMenu getMenuAdmin() {
        return menuAdmin;
    }

    public javax.swing.JMenuItem getMenuAdminClient() {
        return menuAdminClient;
    }

    public javax.swing.JMenuItem getMenuAdminForm() {
        return menuAdminForm;
    }

    public javax.swing.JMenuItem getMenuAdminGroup() {
        return menuAdminGroup;
    }

    public javax.swing.JMenuItem getMenuAdminStatus() {
        return menuAdminStatus;
    }

    public javax.swing.JMenuItem getMenuAdminThesaurus() {
        return menuAdminThesaurus;
    }

    public javax.swing.JMenuItem getMenuAdminXmlStream() {
        return menuAdminXmlStream;
    }

    public javax.swing.JMenu getMenuEmail() {
        return menuEmail;
    }

    public javax.swing.JMenuItem getMenuEmailByClient() {
        return menuEmailByClient;
    }

    public javax.swing.JMenuItem getMenuEmailByForm() {
        return menuEmailByForm;
    }

    public javax.swing.JMenuItem getMenuExport() {
        return menuExport;
    }

    public javax.swing.JMenu getMenuFile() {
        return menuFile;
    }

    public javax.swing.JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public javax.swing.JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public javax.swing.JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public javax.swing.JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public javax.swing.JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public javax.swing.JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public javax.swing.JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public javax.swing.JMenu getMenuForm() {
        return menuForm;
    }

    public javax.swing.JMenu getMenuHelp() {
        return menuHelp;
    }

    public javax.swing.JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public javax.swing.JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public javax.swing.JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public javax.swing.JMenuItem getMenuImport() {
        return menuImport;
    }

    public javax.swing.JMenu getMenuImportExport() {
        return menuImportExport;
    }

    public jaxx.runtime.swing.StatusMessagePanel getStatus() {
        return status;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(content);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuForm);
        menu.add(menuAdmin);
        menu.add(menuEmail);
        menu.add(menuImportExport);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuAdmin() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdmin.add(menuAdminClient);
        menuAdmin.add(menuAdminGroup);
        menuAdmin.add(menuAdminForm);
        menuAdmin.add(menuAdminXmlStream);
        menuAdmin.add(menuAdminStatus);
        menuAdmin.add(menuAdminThesaurus);
    }

    protected void addChildrenToMenuEmail() {
        if (!allComponentsCreated) {
            return;
        }
        menuEmail.add(menuEmailByForm);
        menuEmail.add(menuEmailByClient);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToMenuImportExport() {
        if (!allComponentsCreated) {
            return;
        }
        menuImportExport.add(menuExport);
        menuImportExport.add(menuImport);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new javax.swing.JMenuBar());
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuAdmin() {
        $objectMap.put("menuAdmin", menuAdmin = new javax.swing.JMenu());
        menuAdmin.setName("menuAdmin");
        menuAdmin.setText(_("vradi.menu.admin"));
        menuAdmin.setMnemonic(65);
        menuAdmin.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuAdminClient() {
        $objectMap.put("menuAdminClient", menuAdminClient = new javax.swing.JMenuItem());
        menuAdminClient.setName("menuAdminClient");
        menuAdminClient.setText(_("vradi.menu.client"));
        menuAdminClient.setMnemonic(67);
        menuAdminClient.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminClient"));
        menuAdminClient.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminForm() {
        $objectMap.put("menuAdminForm", menuAdminForm = new javax.swing.JMenuItem());
        menuAdminForm.setName("menuAdminForm");
        menuAdminForm.setText(_("vradi.menu.formType"));
        menuAdminForm.setMnemonic(70);
        menuAdminForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminForm"));
        menuAdminForm.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminGroup() {
        $objectMap.put("menuAdminGroup", menuAdminGroup = new javax.swing.JMenuItem());
        menuAdminGroup.setName("menuAdminGroup");
        menuAdminGroup.setText(_("vradi.menu.group"));
        menuAdminGroup.setMnemonic(71);
        menuAdminGroup.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminGroup"));
        menuAdminGroup.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminStatus() {
        $objectMap.put("menuAdminStatus", menuAdminStatus = new javax.swing.JMenuItem());
        menuAdminStatus.setName("menuAdminStatus");
        menuAdminStatus.setText(_("vradi.menu.status"));
        menuAdminStatus.setMnemonic(83);
        menuAdminStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminStatus"));
        menuAdminStatus.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminThesaurus() {
        $objectMap.put("menuAdminThesaurus", menuAdminThesaurus = new javax.swing.JMenuItem());
        menuAdminThesaurus.setName("menuAdminThesaurus");
        menuAdminThesaurus.setText(_("vradi.menu.thesaurus"));
        menuAdminThesaurus.setMnemonic(84);
        menuAdminThesaurus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminThesaurus"));
        menuAdminThesaurus.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminXmlStream() {
        $objectMap.put("menuAdminXmlStream", menuAdminXmlStream = new javax.swing.JMenuItem());
        menuAdminXmlStream.setName("menuAdminXmlStream");
        menuAdminXmlStream.setText(_("vradi.menu.xmlStream"));
        menuAdminXmlStream.setMnemonic(88);
        menuAdminXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminXmlStream"));
        menuAdminXmlStream.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuEmail() {
        $objectMap.put("menuEmail", menuEmail = new javax.swing.JMenu());
        menuEmail.setName("menuEmail");
        menuEmail.setText(_("vradi.menu.email"));
        menuEmail.setMnemonic(69);
        menuEmail.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuEmailByClient() {
        $objectMap.put("menuEmailByClient", menuEmailByClient = new javax.swing.JMenuItem());
        menuEmailByClient.setName("menuEmailByClient");
        menuEmailByClient.setText(_("vradi.menu.email.client"));
        menuEmailByClient.setMnemonic(67);
        menuEmailByClient.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuEmailByClient"));
        menuEmailByClient.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuEmailByForm() {
        $objectMap.put("menuEmailByForm", menuEmailByForm = new javax.swing.JMenuItem());
        menuEmailByForm.setName("menuEmailByForm");
        menuEmailByForm.setText(_("vradi.menu.email.form"));
        menuEmailByForm.setMnemonic(70);
        menuEmailByForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuEmailByForm"));
        menuEmailByForm.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuExport() {
        $objectMap.put("menuExport", menuExport = new javax.swing.JMenuItem());
        menuExport.setName("menuExport");
        menuExport.setText(_("vradi.menu.importExport.export"));
        menuExport.setMnemonic(69);
        menuExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuExport"));
        menuExport.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new javax.swing.JMenu());
        menuFile.setName("menuFile");
        menuFile.setText(_("vradi.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new javax.swing.JMenuItem());
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("vradi.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("vradi.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new javax.swing.JMenuItem());
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("vradi.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("vradi.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new javax.swing.JMenuItem());
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("vradi.action.fullscreen"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.setToolTipText(_("vradi.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new javax.swing.JMenu());
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("vradi.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("vradi.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new javax.swing.JMenuItem());
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("vradi.action.locale.fr"));
        menuFileLanguageFR.setToolTipText(_("vradi.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new javax.swing.JMenuItem());
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("vradi.action.locale.uk"));
        menuFileLanguageUK.setMnemonic(85);
        menuFileLanguageUK.setToolTipText(_("vradi.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new javax.swing.JMenuItem());
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("vradi.action.normalscreen"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.setToolTipText(_("vradi.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuForm() {
        $objectMap.put("menuForm", menuForm = new javax.swing.JMenu());
        menuForm.setName("menuForm");
        menuForm.setText(_("vradi.menu.form"));
        menuForm.setMnemonic(77);
        menuForm.putClientProperty("help", "ui.main.menu.form");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new javax.swing.JMenu());
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("vradi.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new javax.swing.JMenuItem());
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("vradi.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("vradi.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new javax.swing.JMenuItem());
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("vradi.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("vradi.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new javax.swing.JMenuItem());
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("vradi.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("vradi.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createMenuImport() {
        $objectMap.put("menuImport", menuImport = new javax.swing.JMenuItem());
        menuImport.setName("menuImport");
        menuImport.setText(_("vradi.menu.importExport.import"));
        menuImport.setMnemonic(73);
        menuImport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuImport"));
        menuImport.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuImportExport() {
        $objectMap.put("menuImportExport", menuImportExport = new javax.swing.JMenu());
        menuImportExport.setName("menuImportExport");
        menuImportExport.setText(_("vradi.menu.importExport"));
        menuImportExport.setMnemonic(73);
        menuImportExport.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createStatus() {
        $objectMap.put("status", status = new jaxx.runtime.swing.StatusMessagePanel());
        status.setName("status");
        status.putClientProperty("help", "ui.main.statusBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuAdmin();
        addChildrenToMenuEmail();
        addChildrenToMenuImportExport();
        addChildrenToMenuHelp();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        menuFileConfiguration.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("config"));
        menuFileLanguage.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("translate"));
        menuFileLanguageFR.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("i18n-fr"));
        menuFileLanguageUK.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("i18n-uk"));
        menuFileFullscreen.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("leave-fullscreen"));
        menuFileExit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("exit"));
        menuHelpHelp.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("help"));
        menuHelpSite.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        menuHelpAbout.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("about"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 5 data bindings
        $registerDefaultBindings();
        $objectMap.put("mainFrame", this);
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuForm();
        createMenuAdmin();
        createMenuAdminClient();
        createMenuAdminGroup();
        createMenuAdminForm();
        createMenuAdminXmlStream();
        createMenuAdminStatus();
        createMenuAdminThesaurus();
        createMenuEmail();
        createMenuEmailByForm();
        createMenuEmailByClient();
        createMenuImportExport();
        createMenuExport();
        createMenuImport();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createContent();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1000);
        setTitle(_("vradi.title.welcome"));
        setDefaultCloseOperation(0);
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}