/*
 * *##% 
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.VradiUserImpl;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import static org.nuiton.i18n.I18n._;
import org.nuiton.util.MD5;
import org.nuiton.util.MD5InputStream;
import org.sharengo.exceptions.TechnicalException;

import javax.swing.*;
import java.awt.*;

/**
 * @author morin
 *         Date: 4 déc. 2009
 *         Time: 16:34:04
 */
public class LoginHandler {

    private final static String emptyPassword = "null";

    public VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    public void logUser(LoginUI ui) {
        try {
            String userName = ui.getUserName().getText().trim();
            String password = String.valueOf(ui.getPassword().getPassword()).trim();
            MD5 md5 = new MD5(password);
            VradiUser user = getVradiStorageService().logVradiUser(userName, password.isEmpty() ? emptyPassword : md5.asHex());
            if (user != null) {
                ui.setBean(user);
            } else {
                JOptionPane.showMessageDialog(ui, _("vradi.login.error"), _("vradi.login.error.message"),
                        JOptionPane.ERROR_MESSAGE);
                ui.getUserName().grabFocus();
            }
        } catch (TechnicalException eee) {
            JOptionPane.showMessageDialog(ui, _("vradi.login.error"), _("vradi.login.error.message"),
                    JOptionPane.ERROR_MESSAGE);
        }
    }

    public void register(LoginUI ui) {
        RegisterUI regUI = new RegisterUI(ui);
        regUI.setVisible(true);
    }

    public void register(RegisterUI ui) {
        try {
            String beanPassword = ui.getBean().getPassword();
            String repeatPassword = String.valueOf(ui.getRepeatPassword().getPassword());
            if (beanPassword != null && beanPassword.equals(repeatPassword)) {
                if (beanPassword.isEmpty()) {
                    ui.getBean().setPassword(emptyPassword);
                } else {
                    MD5 md5 = new MD5(beanPassword.trim());
                    ui.getBean().setPassword(md5.asHex());
                }
                VradiUser result = new VradiUserImpl();
                ui.getBean().toWikitty(result);
                result = getVradiStorageService().updateVradiUser(result);
                if (result == null) {
                    JOptionPane.showMessageDialog(ui, _("vradi.register.user.error"), _("vradi.register.user.error.message"),
                            JOptionPane.ERROR_MESSAGE);
                    ui.getUserName().grabFocus();
                    ui.getUserName().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                } else {
                    JOptionPane.showMessageDialog(ui, _("vradi.register.ok"), _("vradi.register.ok.message"),
                            JOptionPane.INFORMATION_MESSAGE);
                    ui.dispose();
                }
            } else {
                JOptionPane.showMessageDialog(ui, _("vradi.register.password.error"), _("vradi.register.password.error.message"),
                        JOptionPane.ERROR_MESSAGE);
                ui.getPassword().grabFocus();
                ui.getPassword().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                ui.getRepeatPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
            }
        } catch (TechnicalException eee) {
            JOptionPane.showMessageDialog(ui, _("vradi.register.password.error"), _("vradi.register.password.error.message"),
                    JOptionPane.ERROR_MESSAGE);
        }
    }

}
