/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.function.ShortFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortField
extends FieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.restrictProps(3072);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return new SortField(field.name, 8, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field) {
        return new ShortFieldSource(field.name);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeShort(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeShort(name, f.stringValue());
    }

    @Override
    public Short toObject(Fieldable f) {
        return Short.valueOf(this.toExternal(f));
    }
}

