/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.models.FieldSelectModel;
import com.jurismarches.vradi.models.FieldTypeModel;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.JListCellRenderer;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.AdminRequestUI;
import com.jurismarches.vradi.ui.admin.VradiNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.AdminStatusUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.FormNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.content.RequestSelectUI;
import com.jurismarches.vradi.ui.admin.content.StatusEditionUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdom.Element;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;

public class AdminHandler {
    private static final Log log = LogFactory.getLog(AdminHandler.class);
    public static final int TOOLTIP_LINE_MAX_CHAR_NB = 100;
    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;
    public static final Map<String, Element> XML_STREAM_FIELDS_CACHE = new HashMap<String, Element>();
    protected static final Comparator<Client> CLIENT_COMPARATOR = new Comparator<Client>(){

        @Override
        public int compare(Client o1, Client o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<User> USER_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User o1, User o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Group> GROUP_COMPARATOR = new Comparator<Group>(){

        @Override
        public int compare(Group o1, Group o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<WikittyExtension> FORM_COMPARATOR = new Comparator<WikittyExtension>(){

        @Override
        public int compare(WikittyExtension o1, WikittyExtension o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected static final Comparator<Status> STATUSES_COMPARATOR = new Comparator<Status>(){

        @Override
        public int compare(Status o1, Status o2) {
            return o1.getValue() - o2.getValue();
        }
    };
    protected static final Comparator<XmlStream> XML_STREAM_COMPARATOR = new Comparator<XmlStream>(){

        @Override
        public int compare(XmlStream o1, XmlStream o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public AdminPopupUI init(JAXXContext rootContext, Object ... datas) {
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            VradiMainUI mainUI = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
            ui = new AdminPopupUI((JAXXContext)context, mainUI);
            VradiContext.ADMIN_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        } else {
            log.info((Object)"Reinit thesaurus");
            ui.getAdminThesaurus().reinit(new ThesaurusTreeHelper((JAXXContext)ui, ThesaurusHandler.PREFIX_EDIT));
        }
        return ui;
    }

    AdminPopupUI getUI(JAXXContext context) {
        if (context instanceof AdminPopupUI) {
            return (AdminPopupUI)context;
        }
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        AdminPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    protected XmlStreamService getXmlStreamService() {
        return ServiceHelper.getXmlStreamService();
    }

    protected boolean answerToDelete(JAXXContext context, String name) {
        AdminPopupUI ui = this.getUI(context);
        int n = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.admin.deleteAnswer") + name + " ?", I18n._((String)"vradi.admin.deleteTitle"), 0);
        return n == 0;
    }

    protected void repaintSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        helper.repaintNode(context, this.getSelectedNode(context, helper));
    }

    protected NavigationTreeNode getSelectedNode(JAXXContext context, VradiNavigationTreeHelper helper) {
        return helper.getSelectedNode(context);
    }

    public void save(Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().updateEntity(entity);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant saving bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + ex));
            ErrorDialogUI.showError((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(JAXXContext context, VradiNavigationTreeHelper helper, Object ... beans) {
        try {
            for (Object bean : beans) {
                log.debug((Object)("will save bean " + bean));
                this.save(bean);
            }
        }
        finally {
            this.repaintSelectedNode(context, helper);
        }
    }

    public boolean answerToSave(AdminContentUI<?> content) {
        if (content != null) {
            log.info((Object)("current content  to close " + content.getClass().getSimpleName() + " : " + content.isModified()));
            if (content.isModified().booleanValue()) {
                int n = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.saveAnswer") + VradiHelper.getEntityName(content.getBean()) + " ?", I18n._((String)"vradi.admin.saveTitle"), 1);
                switch (n) {
                    case 1: {
                        this.cancel(content, content.getHelper(), false);
                        break;
                    }
                    case 0: {
                        content.postSave();
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(JAXXContext context, VradiNavigationTreeHelper helper, Object bean) {
        BusinessEntity entity = (BusinessEntity)bean;
        try {
            this.getVradiStorageService().deleteEntity(entity);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant delete bean : " + entity + " id : " + entity.getWikittyId() + " caused by : " + ex));
            ErrorDialogUI.showError((Exception)ex);
        }
        finally {
            NavigationTreeNode parent = helper.removeChildNode(helper.getSelectedNode(context));
            helper.selectNode(context, parent);
        }
    }

    protected <B> void cancel(AdminContentUI<B> content, VradiNavigationTreeHelper helper, boolean trigerredByCancelButton) {
        int confirm = -1;
        if (trigerredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(content, I18n._((String)"vradi.admin.cancel.message"), I18n._((String)"vradi.admin.cancel.title"), 0, 2);
        }
        if (!trigerredByCancelButton || confirm == 0) {
            B selectedBean = content.getSelectedEntity();
            try {
                content.openUI(helper.getSelectedNode((JAXXContext)content));
            }
            catch (Exception e) {
                log.error((Object)("Cant cancel bean : " + selectedBean + " caused by : " + e), (Throwable)e);
                ErrorDialogUI.showError((Exception)e);
            }
        }
    }

    public ComboBoxModel getTypesModel() {
        FieldTypeModel model = new FieldTypeModel();
        return model;
    }

    public void openRequest(JAXXContext rootContext, List<VradiThesaurusDTO> thesaurus) {
        this.openRequest(rootContext, null, thesaurus);
    }

    public void openRequest(JAXXContext rootContext, String request) {
        this.openRequest(rootContext, request, null);
    }

    public void openRequest(final JAXXContext rootContext, String request, List<VradiThesaurusDTO> thesaurus) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        SearchHandler searchHandler = new SearchHandler();
        OfferListTableModel offerListTableModel = new OfferListTableModel();
        OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        context.add((Object)searchHandler);
        context.add((Object)offerListTableModel);
        context.add((Object)offerListColumnFactory);
        AdminRequestUI requestUI = new AdminRequestUI((JAXXContext)context);
        JXTable listTable = requestUI.getResultTable();
        MouseListener offerListTableMouseListener = this.getOfferListTableMouseListener(requestUI, (JTable)listTable, offerListTableModel);
        listTable.addMouseListener(offerListTableMouseListener);
        TableModelListener offerListTableModelListener = this.getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)renderer);
        listTable.setDefaultRenderer(Date.class, (TableCellRenderer)renderer);
        listTable.setDefaultRenderer(Double.class, (TableCellRenderer)renderer);
        listTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        SearchUI searchUI = searchHandler.initCloneUI((JAXXContext)context, offerListTableModel, thesaurus);
        if (request != null) {
            searchUI.setRequest(request);
        } else if (thesaurus != null) {
            requestUI.setCanSave(false);
            searchUI.setHidable(false);
        }
        requestUI.getSearchPanel().add((Component)((Object)searchUI), "Center");
        VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
        searchHandler.executeQuery((JAXXContext)searchUI, searchUI.getCriterias(), formPageDTO, null, request);
        offerListTableModel.setFormPageDTO(formPageDTO);
        requestUI.addPropertyChangeListener("request", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String newValue = (String)evt.getNewValue();
                RequestSelectUI ui = (RequestSelectUI)rootContext;
                ui.setBean(newValue);
            }
        });
        requestUI.setVisible(true);
    }

    private MouseListener getOfferListTableMouseListener(final AdminRequestUI requestUI, final JTable resultTable, final OfferListTableModel offerListTableModel) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    requestUI.setCursor(Cursor.getPredefinedCursor(3));
                    int row = resultTable.getSelectedRow();
                    Form form = (Form)offerListTableModel.getFormPageDTO().getFormsToShow().get(row);
                    UIHelper.openFormPopup((JAXXContext)requestUI, form);
                    requestUI.setCursor(null);
                }
            }
        };
    }

    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    public List<Status> getAllStatuses() {
        ArrayList values = new ArrayList();
        try {
            values.addAll(this.getVradiStorageService().getAllStatuses());
            Collections.sort(values, STATUSES_COMPARATOR);
        }
        catch (TechnicalException eee) {
            log.error((Object)("Cant get the statuses : " + eee));
            ErrorDialogUI.showError((Exception)eee);
        }
        return new ArrayList<Status>(values);
    }

    public void saveStatuses(AdminStatusUI ui) {
        List<Status> existingStatuses = this.getAllStatuses();
        ArrayList<String> existingStatusIds = new ArrayList<String>();
        for (Status status : existingStatuses) {
            existingStatusIds.add(status.getWikittyId());
        }
        ArrayList<Status> statusesToAdd = new ArrayList<Status>();
        int statusValue = 0;
        for (int i = 0; i < ui.getContent().getComponentCount(); ++i) {
            StatusEditionUI editionUI = (StatusEditionUI)((Object)ui.getContent().getComponent(i));
            Status status = editionUI.getWikitty();
            editionUI.getBean().toWikitty(status);
            if (log.isDebugEnabled()) {
                log.debug((Object)("status to update : " + status.getName()));
            }
            status.setValue(statusValue++);
            statusesToAdd.add(status);
        }
        ArrayList<String> statusesToDelete = new ArrayList<String>();
        for (int i = 0; i < ui.getDeletedContent().getComponentCount(); ++i) {
            StatusEditionUI editionUI = (StatusEditionUI)((Object)ui.getDeletedContent().getComponent(i));
            if (!existingStatusIds.contains(editionUI.getWikitty().getWikittyId())) continue;
            statusesToDelete.add(editionUI.getWikitty().getWikittyId());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("status to delete : " + editionUI.getWikitty().getWikittyId()));
        }
        ui.getDeletedContent().removeAll();
        try {
            this.getVradiStorageService().updateStatuses(statusesToAdd);
            this.getVradiStorageService().deleteStatuses(statusesToDelete);
        }
        catch (TechnicalException eee) {
            log.error((Object)("Cant update the statuses : " + eee));
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    public List<Client> getAllClients(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.CLIENTS.getContextValue(context);
        return new ArrayList<Client>(values);
    }

    public List<User> getAllUsers(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.USERS.getContextValue(context);
        return new ArrayList<User>(values);
    }

    public void createClient(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addClient = helper.addClientToSelected(context, null);
        helper.selectNode(context, addClient);
    }

    public void createUser(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addUser = helper.addUserToSelected(context, null);
        helper.selectNode(context, addUser);
    }

    public List<Group> getAllGroups(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.GROUPS.getContextValue(context);
        return new ArrayList<Group>(values);
    }

    public void createGroup(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addGroup = helper.addGroupToSelected(context, null);
        helper.selectNode(context, addGroup);
    }

    public List<WikittyExtension> getAllForms(JAXXContext context) {
        List values = (List)VradiNavigationTreeHelper.FORMS.getContextValue(context);
        return new ArrayList<WikittyExtension>(values);
    }

    public void createFormType(JAXXContext context, VradiNavigationTreeHelper helper) {
        String name = JOptionPane.showInputDialog(this.getUI(context), (Object)I18n._((String)"vradi.adminForm.askName"));
        if (name != null && !name.isEmpty()) {
            WikittyExtension formType = new WikittyExtension(name, "0.0", "Form", new LinkedHashMap());
            NavigationTreeNode addFormType = helper.addFormTypeToSelected(context, formType);
            helper.selectNode(context, addFormType);
        }
    }

    public void createForms(JAXXContext context) {
        AdminXmlStreamUI ui = this.getXmlStreamUI(context);
        VradiXmlStreamDTO xmlStream = ui.getBean();
        VradiUser vradiUser = ui.getContextValue(VradiUser.class);
        if (xmlStream != null) {
            try {
                log.debug((Object)"create forms");
                Object[] formCreationResults = this.getVradiStorageService().getFormsFromXmlStream((XmlStream)xmlStream, VradiHelper.getLastItemOfXmlStream(xmlStream.getName()), vradiUser);
                if (formCreationResults != null) {
                    boolean warning;
                    String lastItem = (String)formCreationResults[0];
                    VradiHelper.setLastItemOfXmlStream(xmlStream.getName(), lastItem);
                    Integer nbFormCreated = (Integer)formCreationResults[1];
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("nbFormsCreated : " + nbFormCreated));
                    }
                    Integer dateErrorParsing = (Integer)formCreationResults[2];
                    Integer numberErrorParsing = (Integer)formCreationResults[3];
                    boolean bl = warning = dateErrorParsing > 0 || numberErrorParsing > 0;
                    String optionMessage = dateErrorParsing > 0 ? (numberErrorParsing > 0 ? I18n._((String)"vradi.admin.formsCreated.message.allWarning", (Object[])new Object[]{nbFormCreated, dateErrorParsing, numberErrorParsing}) : I18n._((String)"vradi.admin.formsCreated.message.numberWarning", (Object[])new Object[]{nbFormCreated, numberErrorParsing})) : (numberErrorParsing > 0 ? I18n._((String)"vradi.admin.formsCreated.message.dateWarning", (Object[])new Object[]{nbFormCreated, dateErrorParsing, numberErrorParsing}) : I18n._((String)"vradi.admin.formsCreated.message.noWarning", (Object[])new Object[]{nbFormCreated}));
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.admin.formsCreated.message") + optionMessage, I18n._((String)"vradi.admin.formsCreated.title"), warning ? 2 : 1);
                }
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cant create form : " + ex));
                }
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void saveFormType(JAXXContext context, VradiNavigationTreeHelper helper, List<FieldSelectModel> fields, WikittyExtension formType) {
        WikittyExtension newFormType = new WikittyExtension(formType.getName(), formType.getVersion(), formType.getRequires(), null);
        FieldSelectModel[] models = new FieldSelectModel[fields.size()];
        Iterator<FieldSelectModel> i$ = fields.iterator();
        while (i$.hasNext()) {
            FieldSelectModel field;
            models[field.getPosition().intValue()] = field = i$.next();
        }
        for (int i = 0; i < models.length; ++i) {
            FieldSelectModel model = models[i];
            String name = model.getNameValue();
            if (name == null || model.getType() == null) continue;
            FieldType fieldType = model.getType().getFieldType();
            if (model.getDescValue() != null && !model.getDescValue().isEmpty()) {
                fieldType.addTagValue("description", model.getDescValue());
            }
            newFormType.addField(name, fieldType);
        }
        Date now = new Date();
        newFormType.addTagValue("lastModifiedDate", String.format("%1$td/%1$tm/%1$ty", now));
        newFormType.addTagValue("lastModifiedTime", String.format("%1$tk:%1$tM:%1$tS", now));
        newFormType.addTagValue("lastModifiedBy", ((VradiUser)context.getContextValue(VradiUser.class)).getName());
        try {
            this.getVradiStorageService().updateFormType(newFormType);
            NavigationTreeNode selectedNode = helper.getSelectedNode(context);
            List forms = (List)FormNavigationTreeHelper.FORMS.getContextValue(context);
            forms.remove(selectedNode.getBean());
            forms.add(newFormType);
            selectedNode.setBean((Object)newFormType);
            selectedNode.reload(context);
            UIHelper.getHandler(context, SearchHandler.class).getCriterias(context).getFormTypeSelection().setModel(new DefaultComboBoxModel<Object>(VradiHelper.getFormTypes()));
            ((VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context)).updateFormMenu();
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding formType : " + formType.getName() + " id : " + formType.getId() + " caused by : " + ex));
            ErrorDialogUI.showError((Exception)ex);
        }
    }

    public WikittyExtension getExtension(String extensionName) {
        try {
            return this.getVradiStorageService().getFormType(extensionName);
        }
        catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
                ErrorDialogUI.showError((Exception)e);
            }
            return null;
        }
    }

    public void createXmlStream(JAXXContext context, VradiNavigationTreeHelper helper) {
        NavigationTreeNode addXmlStream = helper.addXmlStreamToSelected(context, null);
        helper.selectNode(context, addXmlStream);
    }

    public XmlStream saveXmlStream(JAXXContext context, VradiNavigationTreeHelper helper, XmlStream xmlStream, List<XmlFieldBinding> bindings) {
        XmlStream result = null;
        try {
            bindings = this.getVradiStorageService().updateXmlFieldBindings(bindings);
            xmlStream.clearXmlFieldBinding();
            for (XmlFieldBinding binding : bindings) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(binding.getFormField() + " : " + (binding.getXmlField() != null ? Integer.valueOf(binding.getXmlField().size()) : "null")));
                }
                xmlStream.addXmlFieldBinding(binding.getWikittyId());
            }
            result = (XmlStream)this.getVradiStorageService().updateEntity((BusinessEntity)xmlStream);
            if (log.isDebugEnabled() && result != null) {
                for (String s : result.getXmlFieldBinding()) {
                    log.debug(this.getVradiStorageService().getXmlFieldBinding(s).getXmlField());
                }
            }
            this.repaintSelectedNode(context, helper);
        }
        catch (TechnicalException ex) {
            log.error((Object)("Cant adding client : " + xmlStream.getUrl() + " id : " + xmlStream.getWikittyId() + " caused by : " + ex));
            ErrorDialogUI.showError((Exception)ex);
        }
        return result;
    }

    public List<XmlFieldBinding> getXmlStreamFields(XmlStream xmlStream) {
        ArrayList result;
        try {
            result = this.getVradiStorageService().getXmlFieldBindings(xmlStream);
            if (log.isDebugEnabled()) {
                for (XmlFieldBinding xmlFieldBinding : result) {
                    log.debug((Object)(xmlFieldBinding.getFormField() + " : " + xmlFieldBinding.getXmlField()));
                }
            }
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant get xml stream : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
            result = new ArrayList();
        }
        return result;
    }

    public WikittyExtension getFormType(XmlStream xmlStream) {
        WikittyExtension result;
        block2: {
            String extensionName;
            XmlFieldBinding binding;
            String formField;
            if (xmlStream == null) {
                return null;
            }
            result = this.getExtension(xmlStream.getFormTypeName());
            if (result != null) break block2;
            List<XmlFieldBinding> bindings = this.getXmlStreamFields(xmlStream);
            Iterator<XmlFieldBinding> i$ = bindings.iterator();
            while (i$.hasNext() && ((formField = (binding = i$.next()).getFormField()) == null || "Form".equals(extensionName = formField.substring(0, formField.lastIndexOf(46))) || "Infogene".equals(extensionName) || (result = this.getExtension(extensionName)) == null)) {
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFieldsModel(JAXXContext context) {
        AdminXmlStreamUI ui = this.getXmlStreamUI(context);
        XmlStreamFieldTableModel fieldsModel = this.getXmlStreamUI(context).getFieldsModel();
        fieldsModel.setValueIsAdjusting(true);
        try {
            fieldsModel.clear();
            VradiXmlStreamDTO bean = ui.getBean();
            List<XmlFieldBinding> bindings = this.getXmlStreamFields((XmlStream)bean);
            WikittyExtension formType = bean.getFormType();
            if (formType == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No form type, stop update");
                }
                return;
            }
            String url = bean.getUrl();
            if (url == null || url.trim().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No url, stop update");
                }
                return;
            }
            ArrayList<String> xmlFieldNames = new ArrayList();
            Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
            if (xmlStreamFields.get(url) == null) {
                try {
                    Element firstElement = this.getXmlStreamService().getFirstElement(url);
                    xmlFieldNames = this.getXmlStreamService().getRSSFields(firstElement);
                    xmlStreamFields.put(url, firstElement);
                }
                catch (Exception eee) {
                    log.error((Object)("Can't bind xml stream : " + eee));
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.adminXmlStream.badURL.message"), I18n._((String)"vradi.adminXmlStream.badURL.title"), 0);
                    fieldsModel.fireTableDataChanged();
                    fieldsModel.setValueIsAdjusting(false);
                    return;
                }
            } else {
                xmlFieldNames = this.getXmlStreamService().getRSSFields(xmlStreamFields.get(url));
            }
            ui.getContextValue(JListCellEditor.class).updateUniverse(xmlFieldNames);
            ui.getContextValue(JListCellRenderer.class).updateUniverse(xmlFieldNames);
            if (xmlFieldNames.size() > 0) {
                ui.getFieldsTable().setRowHeight(19 * xmlFieldNames.size());
            }
            LinkedHashMap<String, XmlFieldBinding> fieldNames = new LinkedHashMap<String, XmlFieldBinding>();
            fieldNames.put("Infogene.objet", new XmlFieldBindingImpl());
            fieldNames.put("Infogene.description", new XmlFieldBindingImpl());
            fieldNames.put("Form.datePub", new XmlFieldBindingImpl());
            fieldNames.put("Form.datePeremption", new XmlFieldBindingImpl());
            fieldNames.put("Infogene.entity", new XmlFieldBindingImpl());
            fieldNames.put("Infogene.country", new XmlFieldBindingImpl());
            fieldNames.put("Infogene.department", new XmlFieldBindingImpl());
            for (String fieldName : formType.getFieldNames()) {
                fieldNames.put(formType.getName() + "." + fieldName, new XmlFieldBindingImpl());
            }
            for (XmlFieldBinding binding : bindings) {
                String formField = binding.getFormField();
                if (log.isDebugEnabled()) {
                    log.debug((Object)formField);
                }
                if (fieldNames.get(formField) == null) continue;
                fieldNames.put(formField, binding);
            }
            for (String fieldName : fieldNames.keySet()) {
                XmlFieldBinding binding = (XmlFieldBinding)fieldNames.get(fieldName);
                if (binding == null) continue;
                binding.setFormField(fieldName);
                fieldsModel.addEntry(binding);
            }
        }
        catch (TechnicalException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
                ErrorDialogUI.showError((Exception)e);
            }
        }
        finally {
            fieldsModel.fireTableDataChanged();
            fieldsModel.setValueIsAdjusting(false);
        }
    }

    private AdminXmlStreamUI getXmlStreamUI(JAXXContext context) {
        if (context instanceof AdminXmlStreamUI) {
            return (AdminXmlStreamUI)context;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstElementPreview(JAXXContext context, String url) {
        if (url == null || url.trim().isEmpty()) {
            return "";
        }
        Element firstElement = null;
        Map<String, Element> xmlStreamFields = XML_STREAM_FIELDS_CACHE;
        if (xmlStreamFields.get(url) == null) {
            AdminXmlStreamUI ui = this.getXmlStreamUI(context);
            try {
                ui.setCursor(Cursor.getPredefinedCursor(3));
                firstElement = this.getXmlStreamService().getFirstElement(url);
                xmlStreamFields.put(url, firstElement);
            }
            catch (Exception eee) {
                String string = "";
                return string;
            }
            finally {
                ui.setCursor(null);
            }
        } else {
            firstElement = xmlStreamFields.get(url);
        }
        if (firstElement == null) {
            return "";
        }
        try {
            Map elementValues = this.getXmlStreamService().getFirstElementValues(firstElement);
            StringBuffer result = new StringBuffer();
            result.append("<html>");
            for (Map.Entry entry : elementValues.entrySet()) {
                result.append("<strong>").append((String)entry.getKey()).append("</strong>").append(" : ");
                String value = (String)entry.getValue();
                if (value.length() > 500) {
                    value = StringUtils.replace((String)value, (String)"\r", (String)"");
                    value = StringUtils.replace((String)value, (String)"\n\n", (String)"\n");
                    value = StringUtils.abbreviate((String)value, (int)500);
                    value = StringUtils.replace((String)value, (String)"\n", (String)"<br/>");
                }
                result.append(value).append("<br/>");
            }
            result.append("</html>");
            return result.toString();
        }
        catch (TechnicalException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public void createModel(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createModel");
        }
        try {
            List allForms = this.getVradiStorageService().getAllFormTypes();
            Collections.sort(allForms, FORM_COMPARATOR);
            VradiNavigationTreeHelper.FORMS.setContextValue(context, (Object)allForms);
            List allStatuses = this.getVradiStorageService().getAllStatuses();
            Collections.sort(allStatuses, STATUSES_COMPARATOR);
            VradiNavigationTreeHelper.STATUSES.setContextValue(context, (Object)allStatuses);
            List allGroups = this.getVradiStorageService().getAllGroups();
            Collections.sort(allGroups, GROUP_COMPARATOR);
            VradiNavigationTreeHelper.GROUPS.setContextValue(context, (Object)allGroups);
            List clients = this.getVradiStorageService().getAllClients();
            Collections.sort(clients, CLIENT_COMPARATOR);
            VradiNavigationTreeHelper.CLIENTS.setContextValue(context, (Object)clients);
            List xmlStreams = this.getVradiStorageService().getAllXmlStreams();
            Collections.sort(xmlStreams, XML_STREAM_COMPARATOR);
            VradiNavigationTreeHelper.XMLSTREAMS.setContextValue(context, (Object)xmlStreams);
            ArrayList<User> users = new ArrayList<User>();
            for (Client c : clients) {
                Set<String> usersId = c.getUser();
                if (usersId == null) continue;
                for (String userId : usersId) {
                    User user = this.getVradiStorageService().getUser(userId);
                    users.add(user);
                }
            }
            Collections.sort(users, USER_COMPARATOR);
            VradiNavigationTreeHelper.USERS.setContextValue(context, users);
        }
        catch (TechnicalException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)ex);
        }
    }
}

