/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.VradiUserImpl;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.LoginUI;
import com.jurismarches.vradi.ui.RegisterUI;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.nuiton.i18n.I18n;
import org.nuiton.util.MD5;
import org.sharengo.exceptions.TechnicalException;

public class LoginHandler {
    private static final String emptyPassword = "null";

    public VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    public void logUser(LoginUI ui) {
        try {
            String userName = ui.getUserName().getText().trim();
            String password = String.valueOf(ui.getPassword().getPassword()).trim();
            MD5 md5 = new MD5((Object)password);
            VradiUser user = this.getVradiStorageService().logVradiUser(userName, password.isEmpty() ? emptyPassword : md5.asHex());
            if (user != null) {
                ui.setBean(user);
            } else {
                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.login.error"), I18n._((String)"vradi.login.error.message"), 0);
                ui.getUserName().grabFocus();
            }
        }
        catch (TechnicalException eee) {
            JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.login.error"), I18n._((String)"vradi.login.error.message"), 0);
        }
    }

    public void register(LoginUI ui) {
        RegisterUI regUI = new RegisterUI((JAXXContext)ui);
        regUI.setVisible(true);
    }

    public void register(RegisterUI ui) {
        try {
            String beanPassword = ui.getBean().getPassword();
            String repeatPassword = String.valueOf(ui.getRepeatPassword().getPassword());
            if (beanPassword != null && beanPassword.equals(repeatPassword)) {
                if (beanPassword.isEmpty()) {
                    ui.getBean().setPassword(emptyPassword);
                } else {
                    MD5 md5 = new MD5((Object)beanPassword.trim());
                    ui.getBean().setPassword(md5.asHex());
                }
                VradiUser result = new VradiUserImpl();
                ui.getBean().toWikitty(result);
                result = this.getVradiStorageService().updateVradiUser(result);
                if (result == null) {
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.user.error"), I18n._((String)"vradi.register.user.error.message"), 0);
                    ui.getUserName().grabFocus();
                    ui.getUserName().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                } else {
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.ok"), I18n._((String)"vradi.register.ok.message"), 1);
                    ui.dispose();
                }
            } else {
                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.password.error"), I18n._((String)"vradi.register.password.error.message"), 0);
                ui.getPassword().grabFocus();
                ui.getPassword().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                ui.getRepeatPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
            }
        }
        catch (TechnicalException eee) {
            JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.register.password.error"), I18n._((String)"vradi.register.password.error.message"), 0);
        }
    }
}

