/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.util.ByteUtils;
import org.h2.util.MathUtils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class DataPage {
    public static final int LENGTH_FILLER = 2;
    public static final int LENGTH_INT = 4;
    public static final int LENGTH_LONG = 8;
    private static final boolean CHECKSUM = true;
    private DataHandler handler;
    private byte[] data;
    private int pos;

    private DataPage(DataHandler dataHandler, byte[] byArray) {
        this.handler = dataHandler;
        this.data = byArray;
    }

    public void updateChecksum() {
        int n = this.handler.getChecksum(this.data, 0, this.pos - 2);
        this.data[this.pos - 2] = (byte)n;
    }

    public void check(int n) throws SQLException {
        int n2 = this.handler.getChecksum(this.data, 0, n - 2);
        if (this.data[n - 2] == (byte)n2) {
            return;
        }
        this.handler.handleInvalidChecksum();
    }

    public void setInt(int n, int n2) {
        byte[] byArray = this.data;
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public void writeInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n >> 24);
        byArray[this.pos++] = (byte)(n >> 16);
        byArray[this.pos++] = (byte)(n >> 8);
        byArray[this.pos++] = (byte)n;
    }

    public int readInt() {
        byte[] byArray = this.data;
        return (byArray[this.pos++] << 24) + ((byArray[this.pos++] & 0xFF) << 16) + ((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF);
    }

    public int getStringLen(String string) {
        return DataPage.getStringLenUTF8(string);
    }

    public String readString() {
        byte[] byArray = this.data;
        int n = this.pos;
        int n2 = ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            cArray[i] = (n3 = byArray[n++] & 0xFF) < 128 ? (char)n3 : (n3 >= 224 ? (char)(((n3 & 0xF) << 12) + ((byArray[n++] & 0x3F) << 6) + (byArray[n++] & 0x3F)) : (char)(((n3 & 0x1F) << 6) + (byArray[n++] & 0x3F)));
        }
        this.pos = n;
        return new String(cArray);
    }

    public void writeString(String string) {
        int n = string.length();
        this.checkCapacity(n * 3 + 4);
        int n2 = this.pos;
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n >> 24);
        byArray[n2++] = (byte)(n >> 16);
        byArray[n2++] = (byte)(n >> 8);
        byArray[n2++] = (byte)n;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0000' && c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6);
            byArray[n2++] = (byte)(0x80 | c & 0x3F);
        }
        this.pos = n2;
    }

    public void fill(int n) {
        if (this.pos > n) {
            this.pos = n;
        }
        this.checkCapacity(n - this.pos);
        this.pos = n;
    }

    public static DataPage create(DataHandler dataHandler, int n) {
        return new DataPage(dataHandler, new byte[n]);
    }

    public static DataPage create(DataHandler dataHandler, byte[] byArray) {
        return new DataPage(dataHandler, byArray);
    }

    public void checkCapacity(int n) {
        if (this.pos + n >= this.data.length) {
            byte[] byArray = ByteUtils.newBytes((this.data.length + n) * 2);
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
        }
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void writeDataPageNoSize(DataPage dataPage) {
        this.checkCapacity(dataPage.pos);
        int n = dataPage.pos - 2;
        System.arraycopy(dataPage.data, 0, this.data, this.pos, n);
        this.pos += n;
    }

    public DataPage readDataPageNoSize() {
        int n = this.data.length - this.pos;
        DataPage dataPage = DataPage.create(this.handler, n);
        System.arraycopy(this.data, this.pos, dataPage.data, 0, n);
        dataPage.pos = n;
        return dataPage;
    }

    public void write(byte[] byArray, int n, int n2) {
        this.checkCapacity(n2);
        System.arraycopy(byArray, n, this.data, this.pos, n2);
        this.pos += n2;
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void writeByte(byte by) {
        this.data[this.pos++] = by;
    }

    public int readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public void writeValue(Value value) throws SQLException {
        if (SysProperties.CHECK) {
            this.checkCapacity(8);
        }
        if (value == ValueNull.INSTANCE) {
            this.data[this.pos++] = 45;
            return;
        }
        int n = this.pos;
        this.data[this.pos++] = (byte)(value.getType() + 97);
        switch (value.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.writeInt(value.getInt());
                break;
            }
            case 5: {
                this.writeLong(value.getLong());
                break;
            }
            case 6: {
                String string = value.getString();
                this.writeString(string);
                break;
            }
            case 9: {
                this.writeLong(value.getTimeNoCopy().getTime());
                break;
            }
            case 10: {
                this.writeLong(value.getDateNoCopy().getTime());
                break;
            }
            case 11: {
                Timestamp timestamp = value.getTimestampNoCopy();
                this.writeLong(timestamp.getTime());
                this.writeInt(timestamp.getNanos());
                break;
            }
            case 12: 
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                this.writeInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                this.writeString(value.getString());
                break;
            }
            case 7: {
                this.writeLong(Double.doubleToLongBits(value.getDouble()));
                break;
            }
            case 8: {
                this.writeInt(Float.floatToIntBits(value.getFloat()));
                break;
            }
            case 15: 
            case 16: {
                ValueLob valueLob = (ValueLob)value;
                valueLob.convertToFileIfRequired(this.handler);
                byte[] byArray = valueLob.getSmall();
                if (byArray == null) {
                    int n2 = -2;
                    if (!valueLob.isLinked()) {
                        n2 = -3;
                    }
                    this.writeInt(n2);
                    this.writeInt(valueLob.getTableId());
                    this.writeInt(valueLob.getObjectId());
                    this.writeLong(valueLob.getPrecision());
                    this.writeByte((byte)(valueLob.useCompression() ? 1 : 0));
                    if (n2 != -3) break;
                    this.writeString(valueLob.getFileName());
                    break;
                }
                this.writeInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                this.writeInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(value2);
                }
                break;
            }
            default: {
                Message.throwInternalError("type=" + value.getType());
            }
        }
        if (SysProperties.CHECK2 && this.pos - n != this.getValueLen(value)) {
            throw Message.throwInternalError("value size error: got " + (this.pos - n) + " expected " + this.getValueLen(value));
        }
    }

    public int getValueLen(Value value) throws SQLException {
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        switch (value.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 5;
            }
            case 5: {
                return 9;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 5;
            }
            case 13: 
            case 14: 
            case 21: {
                return 1 + this.getStringLen(value.getString());
            }
            case 6: {
                return 1 + this.getStringLen(value.getString());
            }
            case 12: 
            case 19: {
                int n = value.getBytesNoCopy().length;
                return 5 + n;
            }
            case 20: {
                return 17;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 13;
            }
            case 15: 
            case 16: {
                int n = 1;
                ValueLob valueLob = (ValueLob)value;
                valueLob.convertToFileIfRequired(this.handler);
                byte[] byArray = valueLob.getSmall();
                if (byArray != null) {
                    n += 4 + byArray.length;
                } else {
                    n += 21;
                    if (!valueLob.isLinked()) {
                        n += this.getStringLen(valueLob.getFileName());
                    }
                }
                return n;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                int n = 5;
                for (Value value2 : valueArray) {
                    n += this.getValueLen(value2);
                }
                return n;
            }
        }
        throw Message.throwInternalError("type=" + value.getType());
    }

    public Value readValue() throws SQLException {
        int n;
        if ((n = this.data[this.pos++]) == 45) {
            return ValueNull.INSTANCE;
        }
        switch (n -= 97) {
            case 1: {
                return ValueBoolean.get(this.readInt() == 1);
            }
            case 2: {
                return ValueByte.get((byte)this.readInt());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 10: {
                return ValueDate.getNoCopy(new Date(this.readLong()));
            }
            case 9: {
                return ValueTime.get(new Time(this.readLong()));
            }
            case 11: {
                Timestamp timestamp = new Timestamp(this.readLong());
                timestamp.setNanos(this.readInt());
                return ValueTimestamp.getNoCopy(timestamp);
            }
            case 19: {
                int n2 = this.readInt();
                byte[] byArray = ByteUtils.newBytes(n2);
                this.read(byArray, 0, n2);
                return ValueJavaObject.getNoCopy(byArray);
            }
            case 12: {
                int n3 = this.readInt();
                byte[] byArray = ByteUtils.newBytes(n3);
                this.read(byArray, 0, n3);
                return ValueBytes.getNoCopy(byArray);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(this.readLong()));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(this.readInt()));
            }
            case 15: 
            case 16: {
                int n4 = this.readInt();
                if (n4 >= 0) {
                    byte[] byArray = ByteUtils.newBytes(n4);
                    this.read(byArray, 0, n4);
                    return ValueLob.createSmallLob(n, byArray);
                }
                int n5 = this.readInt();
                int n6 = this.readInt();
                long l = 0L;
                boolean bl = false;
                if (n4 == -2 || n4 == -3) {
                    l = this.readLong();
                    bl = this.readByte() == 1;
                }
                ValueLob valueLob = ValueLob.open(n, this.handler, n5, n6, l, bl);
                if (n4 == -3) {
                    valueLob.setFileName(this.readString(), false);
                }
                return valueLob;
            }
            case 17: {
                int n7 = this.readInt();
                Value[] valueArray = new Value[n7];
                for (int i = 0; i < n7; ++i) {
                    valueArray[i] = this.readValue();
                }
                return ValueArray.get(valueArray);
            }
        }
        throw Message.throwInternalError("type=" + n);
    }

    public void fillAligned() {
        this.fill(MathUtils.roundUp(this.pos + 2, 16));
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public void writeShortInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n >> 8);
        byArray[this.pos++] = (byte)n;
    }

    public int readShortInt() {
        byte[] byArray = this.data;
        return ((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF);
    }

    private static int getStringLenUTF8(String string) {
        int n = 4;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0800') {
                n += 2;
                continue;
            }
            if (c != '\u0000' && c < '\u0080') continue;
            ++n;
        }
        return n2 + n;
    }
}

