/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.editor.config.ConfigCategoryUI;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ConfigUIBuilder {
    public static final Log log = LogFactory.getLog(ConfigUIBuilder.class);

    public static ConfigUI newConfigUI(JAXXContext parentContext, final ConfigUIModel model, String defaultCategory) {
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)parentContext).add((Object)model);
        final ConfigUI ui = new ConfigUI((JAXXContext)tx);
        JButton quitButton = ui.getQuit();
        AbstractAction quitAction = new AbstractAction(quitButton.getText(), quitButton.getIcon()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ConfigUIBuilder.canQuitCategory(ui)) {
                    return;
                }
                if (model.isSaved() && !model.isStandalone()) {
                    StringBuilder buffer = new StringBuilder();
                    for (CategoryModel cat : model) {
                        List<OptionModel> savedOptions = cat.getSavedOptions();
                        if (savedOptions.isEmpty()) continue;
                        buffer.append("\n").append(I18n._((String)"config.category.saved", (Object[])new Object[]{I18n._((String)cat.getCategory())})).append("\n");
                        for (OptionModel option : savedOptions) {
                            buffer.append("\n- ").append(option.getKey());
                        }
                    }
                }
                ui.getParentContainer(Window.class).dispose();
            }
        };
        String tip = quitButton.getToolTipText();
        quitButton.setAction(quitAction);
        quitButton.setToolTipText(tip);
        for (CategoryModel categoryModel : model) {
            String category = categoryModel.getCategory();
            String categoryLabel = I18n._((String)categoryModel.getCategoryLabel());
            ConfigCategoryUI p = new ConfigCategoryUI((JAXXContext)new JAXXInitialContext().add((Object)ui).add((Object)categoryModel));
            p.getCategoryLabel().setText(categoryLabel);
            p.setName(category);
            ui.getCategories().addTab(I18n._((String)category), null, p, categoryLabel);
        }
        model.setCategory(defaultCategory);
        int categoryIndex = model.getCategoryIndex(defaultCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("index of default category (" + defaultCategory + ")  : " + categoryIndex));
        }
        ui.getCategories().setSelectedIndex(categoryIndex);
        return ui;
    }

    public static void showConfigUI(final ConfigUI configUI, Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, true);
        f.setTitle(I18n._((String)"config.title"));
        f.add(configUI);
        if (ui != null) {
            f.setIconImage(ui.getIconImage());
        }
        configUI.getModel().setStandalone(ui == null);
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ActionEvent myEvent = new ActionEvent(e.getSource(), 1, "quit");
                configUI.getQuit().getAction().actionPerformed(myEvent);
            }
        });
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(configUI.getQuit());
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        rootPane.getActionMap().put("quit", configUI.getQuit().getAction());
        f.pack();
        SwingUtil.center((Component)ui, (Component)f);
        f.setVisible(true);
    }

    protected static boolean canQuitCategory(ConfigUI ui) {
        boolean canContinue = true;
        ConfigUIModel model = ui.getModel();
        CategoryModel categoryModel = model.getCategoryModel();
        String categoryName = I18n._((String)categoryModel.getCategory());
        if (!categoryModel.isValid()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(I18n._((String)"config.message.quit.invalid.category", (Object[])new Object[]{categoryName})).append('\n');
            for (OptionModel m : categoryModel.getInvalidOptions()) {
                buffer.append("\n- ").append(m.getKey());
            }
            buffer.append('\n');
            int reponse = ConfigUIBuilder.askUser(ui, I18n._((String)"config.title.need.confirm"), buffer.toString(), 0, new Object[]{I18n._((String)"config.choice.continue"), I18n._((String)"config.choice.cancel")}, 0);
            switch (reponse) {
                case -1: 
                case 1: {
                    canContinue = false;
                    break;
                }
                case 0: {
                    if (!categoryModel.isModified()) break;
                    model.reset();
                }
            }
        } else if (categoryModel.isModified()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(I18n._((String)"config.message.quit.valid.and.modified.category", (Object[])new Object[]{categoryName})).append('\n');
            for (OptionModel m : categoryModel.getModifiedOptions()) {
                buffer.append("\n- ").append(m.getKey());
            }
            buffer.append('\n');
            int reponse = ConfigUIBuilder.askUser(ui, I18n._((String)"config.title.need.confirm"), buffer.toString(), 2, new Object[]{I18n._((String)"config.choice.save"), I18n._((String)"config.choice.doNotSave"), I18n._((String)"config.choice.cancel")}, 0);
            switch (reponse) {
                case -1: 
                case 2: {
                    canContinue = false;
                    break;
                }
                case 0: {
                    model.saveModified();
                    break;
                }
                case 1: {
                    model.reset();
                }
            }
        }
        return canContinue;
    }

    public static int askUser(ConfigUI parent, String title, String message, int typeMessage, Object[] options, int defaultOption) {
        int response = JOptionPane.showOptionDialog(parent, message, title, -1, typeMessage, null, options, options[defaultOption]);
        return response;
    }
}

