/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.PrintStream;
import java.io.PrintWriter;

public class EmailException
extends Exception {
    static final long serialVersionUID = 5550674499282474616L;
    private static final boolean JDK_SUPPORTS_NESTED;
    private final Throwable rootCause;

    public EmailException() {
        this.rootCause = null;
    }

    public EmailException(String msg) {
        super(msg);
        this.rootCause = null;
    }

    public EmailException(Throwable rootCause) {
        super(rootCause == null ? null : rootCause.getMessage());
        this.rootCause = rootCause;
    }

    public EmailException(String msg, Throwable rootCause) {
        super(msg);
        this.rootCause = rootCause;
    }

    public Throwable getCause() {
        return this.rootCause;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            super.printStackTrace(out);
            if (!JDK_SUPPORTS_NESTED && this.rootCause != null) {
                out.print("Caused by: ");
                this.rootCause.printStackTrace(out);
            }
        }
    }

    static {
        boolean flag = false;
        try {
            Throwable.class.getDeclaredMethod("getCause", new Class[0]);
            flag = true;
        }
        catch (NoSuchMethodException ex) {
            flag = false;
        }
        JDK_SUPPORTS_NESTED = flag;
    }
}

