/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nFilter;
import org.nuiton.i18n.I18nLanguage;
import org.nuiton.i18n.I18nStore;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;

public class I18n {
    private static final Log log = LogFactory.getLog(I18n.class);
    public static final String ISO_8859_1_ENCONDING = "ISO-8859-1";
    public static final String UTF_8_ENCONDING = "UTF-8";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    protected static I18nInitializer initializer;
    protected static I18nStore store;
    protected static I18nFilter filter;

    public static void setInitializer(I18nInitializer initializer) {
        I18n.initializer = initializer;
    }

    public static void setFilter(I18nFilter filter) {
        I18n.filter = filter;
    }

    public static void init() {
        I18n.init(null);
    }

    public static void init(String language, String country) {
        I18n.init(I18nUtil.newLocale(language, country));
    }

    public static void init(Locale locale) {
        if (initializer == null) {
            initializer = new ClassPathI18nInitializer();
        }
        if (locale == null) {
            locale = I18nUtil.newLocale(null, null);
        }
        I18n.getStore().setLanguage(locale);
    }

    public static String _(String message) {
        if (message == null) {
            return null;
        }
        I18nLanguage language = I18n.getCurrentLanguage();
        String result = message;
        if (language != null) {
            result = language.translate(message);
        }
        return I18n.applyFilter(result);
    }

    public static String _(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        I18nLanguage language = I18n.getCurrentLanguage();
        String result = message;
        if (language != null) {
            result = language.translate(message);
        }
        try {
            return I18n.applyFilter(String.format(result, args));
        }
        catch (Exception eee) {
            try {
                return I18n.applyFilter(String.format(message, args));
            }
            catch (Exception zzz) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)I18n._("nuitonutil.error.i18n.untranslated.message", message), (Throwable)zzz);
                }
                return I18n.applyFilter(message);
            }
        }
    }

    public static String n_(String message, Object ... args) {
        try {
            return String.format(message, args);
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n._("nuitonutil.error.i18n.unformated.message", message, Arrays.toString(args)), (Throwable)eee);
            }
            return message;
        }
    }

    public static String n_(String message) {
        return message;
    }

    public static void close() {
        if (store != null) {
            store.close();
            store = null;
        }
    }

    public static I18nInitializer getInitializer() {
        return initializer;
    }

    public static I18nStore getStore() {
        if (store == null) {
            store = new I18nStore(DEFAULT_LOCALE, initializer);
        }
        return store;
    }

    protected static String applyFilter(String message) {
        if (I18n.getFilter() != null) {
            return I18n.getFilter().applyFilter(message);
        }
        return message;
    }

    protected static I18nLanguage getCurrentLanguage() {
        I18nLanguage language = store == null ? null : store.getLanguage();
        return language;
    }

    protected static I18nFilter getFilter() {
        return filter;
    }

    @Deprecated
    public static I18nStore getLoader() {
        return I18n.getStore();
    }

    @Deprecated
    public static Locale[] parseLocales(String str) throws IllegalArgumentException {
        return I18nUtil.parseLocales(str);
    }

    @Deprecated
    public static Locale newLocale(String str) {
        return I18nUtil.newLocale(str);
    }

    @Deprecated
    public static Locale newLocale(String language, String country) {
        return I18nUtil.newLocale(language, country);
    }
}

