/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrQueryParser;

class LuceneQParser
extends QParser {
    String sortStr;
    SolrQueryParser lparser;

    public LuceneQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    public Query parse() throws ParseException {
        String qstr = this.getString();
        String defaultField = this.getParam("df");
        if (defaultField == null) {
            defaultField = this.getReq().getSchema().getDefaultSearchFieldName();
        }
        this.lparser = new SolrQueryParser(this, defaultField);
        String opParam = this.getParam("q.op");
        if (opParam != null) {
            this.lparser.setDefaultOperator("AND".equals(opParam) ? QueryParser.Operator.AND : QueryParser.Operator.OR);
        } else {
            QueryParser.Operator operator = this.getReq().getSchema().getSolrQueryParser(null).getDefaultOperator();
            this.lparser.setDefaultOperator(null == operator ? QueryParser.Operator.OR : operator);
        }
        return this.lparser.parse(qstr);
    }

    public String[] getDefaultHighlightFields() {
        return new String[]{this.lparser.getField()};
    }
}

