/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: CompareFilter.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-services/src/main/java/com/jurismarches/vradi/services/search/CompareFilter.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.services.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.math.NumberUtils;

/**
 * <code>CompareFilter</code> is the association of a term and a value.
 * 
 * @author $Author: tchemit $
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 0.0.4
 */
public class CompareFilter implements Filter {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2L;

    protected String term = null;
    protected String value = null;

    public CompareFilter(String term, String value) {
        this.term = term;
        this.value = value;
    }

    public String getName() {
        return term;
    }

    public void setName(String name) {
        this.term = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.format("%s = %s", term, value);
    }
    
    public boolean isBoolean() {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return true;
        }
        return false;
    }
    
    public boolean isNumber() {
        return NumberUtils.isNumber(value);
    }
    
    public boolean isPhrase() {
        int indexOf = value.indexOf(' ');
        if (indexOf > -1) {
            return true;
        }
        return false;
    }
    
    public boolean match(Pattern pattern) {
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }
}
