/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.locks.ReentrantLock;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ReentrantLockTest {
    ReentrantLock lock;

    @BeforeMethod
    public void setUp() throws Exception {
        this.lock = new ReentrantLock();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        ReentrantLockTest.releaseAll(this.lock);
        this.lock = null;
    }

    public void testAcquireLock() {
        this.lock.lock();
        Assert.assertEquals((int)1, (int)this.lock.getHoldCount());
        this.lock.lock();
        Assert.assertEquals((int)2, (int)this.lock.getHoldCount());
        ReentrantLockTest.release(this.lock);
        Assert.assertEquals((int)1, (int)this.lock.getHoldCount());
        ReentrantLockTest.release(this.lock);
        Assert.assertEquals((int)0, (int)this.lock.getHoldCount());
    }

    public void testAcquireLock2() {
        this.lock.lock();
        Assert.assertEquals((int)1, (int)this.lock.getHoldCount());
        this.lock.lock();
        Assert.assertEquals((int)2, (int)this.lock.getHoldCount());
        ReentrantLockTest.releaseAll(this.lock);
        Assert.assertEquals((int)0, (int)this.lock.getHoldCount());
    }

    private static void release(ReentrantLock lock) {
        if (lock != null && lock.getHoldCount() > 0) {
            lock.unlock();
        }
    }

    private static void releaseAll(ReentrantLock lock) {
        long holds;
        if (lock != null && (holds = (long)lock.getHoldCount()) > 0L) {
            int i = 0;
            while ((long)i < holds) {
                lock.unlock();
                ++i;
            }
        }
    }
}

