/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@Unsupported
@MBean(description="Discards messages")
public class DISCARD
extends Protocol {
    @Property
    double up = 0.0;
    @Property
    double down = 0.0;
    @Property
    boolean excludeItself = true;
    Address localAddress;
    @ManagedAttribute(description="Number of dropped down messages", name="droppedDownMessages")
    int num_down = 0;
    @ManagedAttribute(description="Number of dropped up messages", name="droppedUpMessages")
    int num_up = 0;
    final Set<Address> ignoredMembers = new HashSet<Address>();
    final Collection<Address> members = new ArrayList<Address>();
    @ManagedAttribute(description="drop all messages (up or down)", writable=true)
    boolean discard_all = false;
    @ManagedAttribute(description="Number of subsequent unicasts to drop in the down direction", writable=true)
    int drop_down_unicasts = 0;
    @ManagedAttribute(description="Number of subsequent multicasts to drop in the down direction", writable=true)
    int drop_down_multicasts = 0;
    private DiscardDialog discard_dialog = null;
    @Property(name="gui", description="use a GUI or not")
    protected boolean use_gui = false;

    public boolean isDiscardAll() {
        return this.discard_all;
    }

    public void setDiscardAll(boolean discard_all) {
        this.discard_all = discard_all;
    }

    public boolean isExcludeItself() {
        return this.excludeItself;
    }

    public void setLocalAddress(Address localAddress) {
        this.localAddress = localAddress;
        if (this.discard_dialog != null) {
            this.discard_dialog.setTitle(localAddress != null ? localAddress.toString() : "n/a");
        }
    }

    public void setExcludeItself(boolean excludeItself) {
        this.excludeItself = excludeItself;
    }

    public double getUpDiscardRate() {
        return this.up;
    }

    public void setUpDiscardRate(double up2) {
        this.up = up2;
    }

    public double getDownDiscardRate() {
        return this.down;
    }

    public void setDownDiscardRate(double down2) {
        this.down = down2;
    }

    public int getDropDownUnicasts() {
        return this.drop_down_unicasts;
    }

    public void setDropDownUnicasts(int drop_down_unicasts) {
        this.drop_down_unicasts = drop_down_unicasts;
    }

    public int getDropDownMulticasts() {
        return this.drop_down_multicasts;
    }

    public void setDropDownMulticasts(int drop_down_multicasts) {
        this.drop_down_multicasts = drop_down_multicasts;
    }

    public void addIgnoreMember(Address sender) {
        this.ignoredMembers.add(sender);
    }

    public void removeIgnoredMember(Address member) {
        this.ignoredMembers.remove(member);
    }

    public void resetIgnoredMembers() {
        this.ignoredMembers.clear();
    }

    @ManagedOperation
    public void startGui() {
        if (this.discard_dialog == null) {
            this.discard_dialog = new DiscardDialog();
            this.discard_dialog.init();
            this.discard_dialog.setTitle(this.localAddress != null ? this.localAddress.toString() : "n/a");
            this.discard_dialog.handleView(this.members);
        }
    }

    @ManagedOperation
    public void stopGui() {
        if (this.discard_dialog != null) {
            this.discard_dialog.dispose();
        }
        this.discard_dialog = null;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.use_gui) {
            this.discard_dialog = new DiscardDialog();
            this.discard_dialog.init();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.discard_dialog != null) {
            this.discard_dialog.dispose();
        }
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 8) {
            this.localAddress = (Address)evt.getArg();
            if (this.discard_dialog != null) {
                this.discard_dialog.setTitle("Discard dialog (" + this.localAddress + ")");
            }
        }
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            Address sender = msg.getSrc();
            if (this.discard_all && !sender.equals(this.localAddress)) {
                return null;
            }
            DiscardHeader dh = (DiscardHeader)msg.getHeader(this.id);
            if (dh != null) {
                this.ignoredMembers.clear();
                this.ignoredMembers.addAll(dh.dropMessages);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("will potentially drop messages from " + this.ignoredMembers);
                }
            } else {
                double r;
                boolean dropMessage = this.ignoredMembers.contains(sender);
                if (dropMessage) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.localAddress + ": dropping message from " + sender);
                    }
                    ++this.num_up;
                    return null;
                }
                if (this.up > 0.0 && (r = Math.random()) < this.up) {
                    if (this.excludeItself && sender.equals(this.localAddress)) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("excluding itself");
                        }
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.localAddress + ": dropping message from " + sender);
                        }
                        ++this.num_up;
                        return null;
                    }
                }
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                double r;
                boolean multicast;
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                boolean bl = multicast = dest == null || dest.isMulticastAddress();
                if (msg.getSrc() == null) {
                    msg.setSrc(this.localAddress);
                }
                if (this.discard_all) {
                    if (dest == null || dest.isMulticastAddress() || dest.equals(this.localAddress)) {
                        this.loopback(msg);
                    }
                    return null;
                }
                if (!multicast && this.drop_down_unicasts > 0) {
                    this.drop_down_unicasts = Math.max(0, this.drop_down_unicasts - 1);
                    return null;
                }
                if (multicast && this.drop_down_multicasts > 0) {
                    this.drop_down_multicasts = Math.max(0, this.drop_down_multicasts - 1);
                    return null;
                }
                if (!(this.down > 0.0) || !((r = Math.random()) < this.down)) break;
                if (this.excludeItself && msg.getSrc().equals(this.localAddress)) {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("excluding itself");
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("dropping message");
                }
                ++this.num_down;
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                Vector<Address> mbrs = view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.ignoredMembers.retainAll(mbrs);
                if (this.discard_dialog == null) break;
                this.discard_dialog.handleView(mbrs);
                break;
            }
            case 8: {
                this.localAddress = (Address)evt.getArg();
                if (this.discard_dialog == null) break;
                this.discard_dialog.setTitle("Discard dialog (" + this.localAddress + ")");
            }
        }
        return this.down_prot.down(evt);
    }

    private void loopback(Message msg) {
        final Message rsp = msg.copy(true);
        if (rsp.getSrc() == null) {
            rsp.setSrc(this.localAddress);
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DISCARD.this.up_prot.up(new Event(1, rsp));
            }
        });
        thread.start();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_up = 0;
        this.num_down = 0;
    }

    @Override
    public Map<String, Object> dumpStats() {
        HashMap<String, Object> m = new HashMap<String, Object>(2);
        m.put("num_dropped_down", new Integer(this.num_down));
        m.put("num_dropped_up", new Integer(this.num_up));
        return m;
    }

    private static class MyCheckBox
    extends JCheckBox {
        final Address mbr;

        public MyCheckBox(String name, Address member) {
            super(name);
            this.mbr = member;
        }

        @Override
        public String toString() {
            return super.toString() + " [mbr=" + this.mbr + "]";
        }
    }

    private class DiscardDialog
    extends JFrame
    implements ActionListener {
        private JButton start_discarding_button = new JButton("start discarding");
        private JButton stop_discarding_button = new JButton("stop discarding");
        JPanel checkboxes = new JPanel();

        private DiscardDialog() {
        }

        void init() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.checkboxes.setLayout(new BoxLayout(this.checkboxes, 1));
            this.getContentPane().add(this.start_discarding_button);
            this.getContentPane().add(this.stop_discarding_button);
            this.start_discarding_button.addActionListener(this);
            this.stop_discarding_button.addActionListener(this);
            this.getContentPane().add(this.checkboxes);
            this.pack();
            this.setVisible(true);
            this.setTitle(DISCARD.this.localAddress != null ? DISCARD.this.localAddress.toString() : "n/a");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.startsWith("start")) {
                DISCARD.this.discard_all = true;
            } else if (command.startsWith("stop")) {
                Component[] comps;
                DISCARD.this.discard_all = false;
                for (Component c : comps = this.checkboxes.getComponents()) {
                    if (!(c instanceof JCheckBox)) continue;
                    ((JCheckBox)c).setSelected(false);
                }
            }
        }

        void handleView(Collection<Address> mbrs) {
            this.checkboxes.removeAll();
            for (final Address addr : mbrs) {
                final MyCheckBox box = new MyCheckBox("discard traffic from " + addr, addr);
                box.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (box.isSelected()) {
                            DISCARD.this.ignoredMembers.add(addr);
                        } else {
                            DISCARD.this.ignoredMembers.remove(addr);
                        }
                    }
                });
                this.checkboxes.add(box);
            }
            for (Component comp : this.checkboxes.getComponents()) {
                MyCheckBox box = (MyCheckBox)comp;
                if (!DISCARD.this.ignoredMembers.contains(box.mbr)) continue;
                box.setSelected(true);
            }
            this.pack();
        }
    }

    public static class DiscardHeader
    extends Header {
        private final Set<Address> dropMessages;

        public DiscardHeader() {
            this.dropMessages = new HashSet<Address>();
        }

        public DiscardHeader(Set<Address> ignoredAddresses) {
            this.dropMessages = ignoredAddresses;
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int size = in.readShort();
            if (size > 0) {
                this.dropMessages.clear();
                for (int i = 0; i < size; ++i) {
                    this.dropMessages.add(Util.readAddress(in));
                }
            }
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            if (this.dropMessages != null && !this.dropMessages.isEmpty()) {
                out.writeShort(this.dropMessages.size());
                for (Address addr : this.dropMessages) {
                    Util.writeAddress(addr, out);
                }
            } else {
                out.writeShort(0);
            }
        }

        @Override
        public int size() {
            return (int)Util.size(this.dropMessages);
        }
    }
}

