/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.QueryMakerBean;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:23:27
 */
public class VradiQueryMakerDTO extends QueryMakerBean implements VradiDTO<QueryMaker> {

    private static final long serialVersionUID = 1L;

    protected List<VradiQueryBean> impactedQueries = null;

    protected String name = null;

    public VradiQueryMakerDTO() {
        QueryMaker$queries = new HashSet<String>();
        impactedQueries = new ArrayList<VradiQueryBean>();
    }

    @Override
    public void fromWikitty(QueryMaker wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());

            if (wikitty.getExtensionNames().contains(ModificationTag.EXT_MODIFICATION_TAG)) {
                Object lastModified = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIED);
                setLastModified(lastModified != null ? (Date) lastModified : null);
                Object lastModifier = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIER);
                setLastModifier(lastModifier != null ? (String) lastModifier : null);
            } else {
                setLastModified(null);
                setLastModifier(null);
            }

            QueryMaker$queries.clear();
            addAllQueries(wikitty.getQueries());

        }
    }

    public void reset() {
        setWikittyId(null);
        setLastModified(null);
        setLastModifier(null);
        clearQueries();
        impactedQueries.clear();
    }

    @Override
    public void toWikitty(QueryMaker wikitty) {
        wikitty.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, getLastModified());
        wikitty.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER, getLastModifier());

        wikitty.clearQueries();
        for (String id : getQueries()) {
            wikitty.addQueries(id);
        }
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public List<VradiQueryBean> getImpactedQueries() {
        return impactedQueries;
    }

    public void setImpactedQueries(List<VradiQueryBean> queries) {
        impactedQueries = queries;
    }

    public Date getLastModified() {
        return (Date) this.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED);
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = getLastModified();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, lastModified);
        propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String) this.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER);
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = getLastModifier();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER, lastModifier);
        propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    private void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                QueryMaker$queries.add(s);
            }
        }
        propertyChange.firePropertyChange("queries", null, QueryMaker$queries);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        propertyChange.firePropertyChange("lastModifier", oldValue, name);
    }

}