/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.search;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

/**
 * a <code>QueryHandler</code> is able to handle lucene queries.
 * 
 * @author $Author: schorlet $
 * @version $Revision: 439 $ $Date: 2010-01-24 15:27:45 +0100 (dim., 24 janv. 2010) $
 * @since 0.0.4
 */
public interface QueryHandler {

    /**
     * handles a <code>TermQuery</code>.
     * 
     * @param termquery
     * @param booleanClause
     */
    void termQuery(TermQuery termquery, BooleanClause booleanClause);

    /**
     * handles a <code>PrefixQuery</code>.
     * 
     * @param prefixquery
     * @param booleanClause
     */
    void prefixQuery(PrefixQuery prefixquery, BooleanClause booleanClause);

    /**
     * handles a <code>WildcardQuery</code>.
     * 
     * @param wildcardquery
     * @param booleanClause
     */
    void wildcardQuery(WildcardQuery wildcardquery, BooleanClause booleanClause);

    /**
     * handles a <code>RangeQuery</code>.
     * 
     * @param rangequery
     * @param booleanClause
     */
    void rangeQuery(RangeQuery rangequery, BooleanClause booleanClause);

    /**
     * indicates the start of new group of queries.
     * 
     * @param booleanClause
     */
    void group(BooleanClause booleanClause);

    /**
     * indicates the end of the current group.
     */
    void ungroup();
}
