/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.EnumSet;
import javax.servlet.Filter;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextHandler
extends ContextHandler {
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    protected Class<? extends SecurityHandler> _defaultSecurityHandlerClass = ConstraintSecurityHandler.class;
    protected SessionHandler _sessionHandler;
    protected SecurityHandler _securityHandler;
    protected ServletHandler _servletHandler;
    protected int _options;

    public ServletContextHandler() {
        this(null, null, null, null, null);
    }

    public ServletContextHandler(int options) {
        this(null, null, options);
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath) {
        this(parent, contextPath, null, null, null, null);
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath, int options) {
        this(parent, contextPath, null, null, null, null);
        this._options = options;
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath, boolean sessions, boolean security) {
        this(parent, contextPath, (sessions ? 1 : 0) | (security ? 2 : 0));
    }

    public ServletContextHandler(HandlerContainer parent, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(parent, null, sessionHandler, securityHandler, servletHandler, errorHandler);
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super((ContextHandler.Context)null);
        this._scontext = new Context();
        this._sessionHandler = sessionHandler;
        this._securityHandler = securityHandler;
        this._servletHandler = servletHandler;
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        if (parent instanceof HandlerWrapper) {
            ((HandlerWrapper)parent).setHandler(this);
        } else if (parent instanceof HandlerCollection) {
            ((HandlerCollection)parent).addHandler(this);
        }
    }

    public Class<? extends SecurityHandler> getDefaultSecurityHandlerClass() {
        return this._defaultSecurityHandlerClass;
    }

    public void setDefaultSecurityHandlerClass(Class<? extends SecurityHandler> defaultSecurityHandlerClass) {
        this._defaultSecurityHandlerClass = defaultSecurityHandlerClass;
    }

    protected SessionHandler newSessionHandler() {
        return new SessionHandler();
    }

    protected SecurityHandler newSecurityHandler() {
        try {
            return this._defaultSecurityHandlerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected ServletHandler newServletHandler() {
        return new ServletHandler();
    }

    @Override
    protected void startContext() throws Exception {
        HandlerWrapper wrapper;
        this.getSessionHandler();
        this.getSecurityHandler();
        this.getServletHandler();
        HandlerWrapper handler = this._servletHandler;
        if (this._securityHandler != null) {
            this._securityHandler.setHandler(handler);
            handler = this._securityHandler;
        }
        if (this._sessionHandler != null) {
            this._sessionHandler.setHandler(handler);
            handler = this._sessionHandler;
        }
        for (wrapper = this; wrapper != handler && wrapper.getHandler() instanceof HandlerWrapper; wrapper = (HandlerWrapper)wrapper.getHandler()) {
        }
        if (wrapper != handler) {
            if (wrapper.getHandler() != null) {
                throw new IllegalStateException("!ScopedHandler");
            }
            wrapper.setHandler(handler);
        }
        super.startContext();
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            this._servletHandler.initialize();
        }
    }

    public SecurityHandler getSecurityHandler() {
        if (this._securityHandler == null && (this._options & 2) != 0 && !this.isStarted()) {
            this._securityHandler = this.newSecurityHandler();
        }
        return this._securityHandler;
    }

    public ServletHandler getServletHandler() {
        if (this._servletHandler == null && !this.isStarted()) {
            this._servletHandler = this.newServletHandler();
        }
        return this._servletHandler;
    }

    public SessionHandler getSessionHandler() {
        if (this._sessionHandler == null && (this._options & 1) != 0 && !this.isStarted()) {
            this._sessionHandler = this.newSessionHandler();
        }
        return this._sessionHandler;
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this.getServletHandler().addServletWithMapping(className, pathSpec);
    }

    public ServletHolder addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        return this.getServletHandler().addServletWithMapping(servlet.getName(), pathSpec);
    }

    public void addServlet(ServletHolder servlet, String pathSpec) {
        this.getServletHandler().addServletWithMapping(servlet, pathSpec);
    }

    public void addFilter(FilterHolder holder, String pathSpec, int dispatches) {
        this.getServletHandler().addFilterWithMapping(holder, pathSpec, dispatches);
    }

    public FilterHolder addFilter(Class<? extends Filter> filterClass, String pathSpec, int dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, int dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        this._sessionHandler = sessionHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        this._securityHandler = securityHandler;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        this._servletHandler = servletHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Context
    extends ContextHandler.Context {
        @Override
        public RequestDispatcher getNamedDispatcher(String name) {
            ServletContextHandler context = ServletContextHandler.this;
            if (ServletContextHandler.this._servletHandler == null || ServletContextHandler.this._servletHandler.getServlet(name) == null) {
                return null;
            }
            return new Dispatcher(context, name);
        }

        public void addFilterMappingForServletNames(String filterName, EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
            if (ServletContextHandler.this.isStarted()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(filterName);
            mapping.setServletNames(servletNames);
            mapping.setDispatcherTypes(dispatcherTypes);
            handler.addFilterMapping(mapping);
        }

        public void addServletMapping(String servletName, String[] urlPatterns) {
            if (ServletContextHandler.this.isStarted()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.newServletHolder();
            holder.setName(servletName);
            handler.addServlet(holder);
        }
    }
}

