/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.jasper.runtime.ELContextImpl;
import org.apache.jasper.runtime.VariableResolverImpl;

public class ExpressionEvaluatorImpl
extends ExpressionEvaluator {
    private PageContext pageContext;

    public ExpressionEvaluatorImpl(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Expression parseExpression(String expression, Class expectedType, FunctionMapper fMapper) throws ELException {
        ValueExpression expr;
        ExpressionFactory fac = ExpressionFactory.newInstance();
        ELContextImpl elContext = new ELContextImpl(null);
        FunctionMapperWrapper fm = new FunctionMapperWrapper(fMapper);
        elContext.setFunctionMapper(fm);
        try {
            expr = fac.createValueExpression(elContext, expression, expectedType);
        }
        catch (javax.el.ELException ex) {
            throw new ELException(ex);
        }
        return new ExpressionImpl(expr, this.pageContext);
    }

    public Object evaluate(String expression, Class expectedType, VariableResolver vResolver, FunctionMapper fMapper) throws ELException {
        Object value;
        ELContextImpl elContext = vResolver instanceof VariableResolverImpl ? (ELContextImpl)this.pageContext.getELContext() : new ELContextImpl(new ELResolverWrapper(vResolver));
        FunctionMapperWrapper fm = new FunctionMapperWrapper(fMapper);
        elContext.setFunctionMapper(fm);
        ExpressionFactory fac = ExpressionFactory.newInstance();
        try {
            ValueExpression expr = fac.createValueExpression(elContext, expression, expectedType);
            value = expr.getValue(elContext);
        }
        catch (javax.el.ELException ex) {
            throw new ELException(ex);
        }
        return value;
    }

    private static class ELResolverWrapper
    extends ELResolver {
        private VariableResolver vResolver;

        ELResolverWrapper(VariableResolver vResolver) {
            this.vResolver = vResolver;
        }

        public Object getValue(ELContext context, Object base, Object property) throws javax.el.ELException {
            if (base == null) {
                context.setPropertyResolved(true);
                try {
                    return this.vResolver.resolveVariable(property.toString());
                }
                catch (ELException ex) {
                    throw new javax.el.ELException(ex);
                }
            }
            return null;
        }

        public Class getType(ELContext context, Object base, Object property) throws javax.el.ELException {
            return null;
        }

        public void setValue(ELContext context, Object base, Object property, Object value) throws javax.el.ELException {
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) throws javax.el.ELException {
            return false;
        }

        public Iterator getFeatureDescriptors(ELContext context, Object base) {
            return null;
        }

        public Class getCommonPropertyType(ELContext context, Object base) {
            return null;
        }
    }

    private static class FunctionMapperWrapper
    extends javax.el.FunctionMapper {
        private FunctionMapper mapper;

        FunctionMapperWrapper(FunctionMapper mapper) {
            this.mapper = mapper;
        }

        public Method resolveFunction(String prefix, String localName) {
            return this.mapper.resolveFunction(prefix, localName);
        }
    }

    private static class ExpressionImpl
    extends Expression {
        private ValueExpression valueExpr;
        private PageContext pageContext;

        ExpressionImpl(ValueExpression valueExpr, PageContext pageContext) {
            this.valueExpr = valueExpr;
            this.pageContext = pageContext;
        }

        public Object evaluate(VariableResolver vResolver) throws ELException {
            ELContext elContext = vResolver instanceof VariableResolverImpl ? this.pageContext.getELContext() : new ELContextImpl(new ELResolverWrapper(vResolver));
            try {
                return this.valueExpr.getValue(elContext);
            }
            catch (javax.el.ELException ex) {
                throw new ELException(ex);
            }
        }
    }
}

