/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class FormLinkHelper {

    /**
     * FormLinkHelper :
     * utility class all provided methods are accessible the static way
     */

    private FormLinkHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_NAME, name);
        return oldValue;
}

    /**
     * getType :
     * @param wikitty 
     * @return int 
     */

    public static int getType(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TYPE);
        return value;
}

    /**
     * setType :
     * @param wikitty 
     * @param type 
     * @return int 
     */

    public static int setType(Wikitty wikitty, int type) {
        int oldValue = getType(wikitty);
        wikitty.setField(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TYPE, type);
        return oldValue;
}

    /**
     * getFromForm :
     * @param wikitty 
     * @return String 
     */

    public static String getFromForm(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_FROMFORM);
        return value;
}

    /**
     * setFromForm :
     * @param wikitty 
     * @param fromForm 
     * @return String 
     */

    public static String setFromForm(Wikitty wikitty, String fromForm) {
        String oldValue = getFromForm(wikitty);
        wikitty.setField(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_FROMFORM, fromForm);
        return oldValue;
}

    /**
     * getToForm :
     * @param wikitty 
     * @return String 
     */

    public static String getToForm(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TOFORM);
        return value;
}

    /**
     * setToForm :
     * @param wikitty 
     * @param toForm 
     * @return String 
     */

    public static String setToForm(Wikitty wikitty, String toForm) {
        String oldValue = getToForm(wikitty);
        wikitty.setField(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TOFORM, toForm);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_NAME);
            Object f2 = w2.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TYPE);
            Object f2 = w2.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TYPE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_FROMFORM);
            Object f2 = w2.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_FROMFORM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TOFORM);
            Object f2 = w2.getFieldAsObject(FormLink.EXT_FORMLINK, FormLink.FIELD_FORMLINK_TOFORM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(FormLink.EXT_FORMLINK);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : FormLinkAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //FormLinkHelper
