/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class UserAbstract extends BusinessEntityImpl implements User {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionUser;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = UserHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        UserHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_NAME, oldValue, getName());
}

    /**
     * getService :
     * @return String 
     */

    @Override
    public String getService() {
        String value = UserHelper.getService(getWikitty());
        return value;
}

    /**
     * setService :
     * @param service 
     */

    @Override
    public void setService(String service) {
        String oldValue = getService();
        UserHelper.setService(getWikitty(), service);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_SERVICE, oldValue, getService());
}

    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        String value = UserHelper.getEmail(getWikitty());
        return value;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        String oldValue = getEmail();
        UserHelper.setEmail(getWikitty(), email);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_EMAIL, oldValue, getEmail());
}

    /**
     * getCreationDate :
     * @return Date 
     */

    @Override
    public Date getCreationDate() {
        Date value = UserHelper.getCreationDate(getWikitty());
        return value;
}

    /**
     * setCreationDate :
     * @param creationDate 
     */

    @Override
    public void setCreationDate(Date creationDate) {
        Date oldValue = getCreationDate();
        UserHelper.setCreationDate(getWikitty(), creationDate);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_CREATIONDATE, oldValue, getCreationDate());
}

    /**
     * getValidEmail :
     * @return boolean 
     */

    @Override
    public boolean getValidEmail() {
        boolean value = UserHelper.getValidEmail(getWikitty());
        return value;
}

    /**
     * setValidEmail :
     * @param validEmail 
     */

    @Override
    public void setValidEmail(boolean validEmail) {
        boolean oldValue = getValidEmail();
        UserHelper.setValidEmail(getWikitty(), validEmail);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_VALIDEMAIL, oldValue, getValidEmail());
}

    /**
     * getAddress :
     * @return String 
     */

    @Override
    public String getAddress() {
        String value = UserHelper.getAddress(getWikitty());
        return value;
}

    /**
     * setAddress :
     * @param address 
     */

    @Override
    public void setAddress(String address) {
        String oldValue = getAddress();
        UserHelper.setAddress(getWikitty(), address);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_ADDRESS, oldValue, getAddress());
}

    /**
     * getPhone :
     * @return String 
     */

    @Override
    public String getPhone() {
        String value = UserHelper.getPhone(getWikitty());
        return value;
}

    /**
     * setPhone :
     * @param phone 
     */

    @Override
    public void setPhone(String phone) {
        String oldValue = getPhone();
        UserHelper.setPhone(getWikitty(), phone);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_PHONE, oldValue, getPhone());
}

    /**
     * getBeginSearchDate :
     * @return Date 
     */

    @Override
    public Date getBeginSearchDate() {
        Date value = UserHelper.getBeginSearchDate(getWikitty());
        return value;
}

    /**
     * setBeginSearchDate :
     * @param beginSearchDate 
     */

    @Override
    public void setBeginSearchDate(Date beginSearchDate) {
        Date oldValue = getBeginSearchDate();
        UserHelper.setBeginSearchDate(getWikitty(), beginSearchDate);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_BEGINSEARCHDATE, oldValue, getBeginSearchDate());
}

    /**
     * getEnable :
     * @return boolean 
     */

    @Override
    public boolean getEnable() {
        boolean value = UserHelper.getEnable(getWikitty());
        return value;
}

    /**
     * setEnable :
     * @param enable 
     */

    @Override
    public void setEnable(boolean enable) {
        boolean oldValue = getEnable();
        UserHelper.setEnable(getWikitty(), enable);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_ENABLE, oldValue, getEnable());
}

    /**
     * getClient :
     * @return String 
     */

    @Override
    public String getClient() {
        String value = UserHelper.getClient(getWikitty());
        return value;
}

    /**
     * setClient :
     * @param client 
     */

    @Override
    public void setClient(String client) {
        String oldValue = getClient();
        UserHelper.setClient(getWikitty(), client);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_CLIENT, oldValue, getClient());
}

    /**
     * UserAbstract :
     */

    public UserAbstract() {
        super();
}

    /**
     * UserAbstract :
     * @param wikitty 
     */

    public UserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * UserAbstract :
     * @param businessEntityImpl 
     */

    public UserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionUser =
                new WikittyExtension(EXT_USER,
                                     "6.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "String service unique=\"true\"", 
                                             "String email unique=\"true\"", 
                                             "Date creationDate unique=\"true\"", 
                                             "boolean validEmail unique=\"true\"", 
                                             "String address unique=\"true\"", 
                                             "String phone unique=\"true\"", 
                                             "Date beginSearchDate unique=\"true\"", 
                                             "boolean enable unique=\"true\"", 
                                             "Wikitty client unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionUser);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //UserAbstract
