/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class SendingHelper {

    /**
     * SendingHelper :
     * utility class all provided methods are accessible the static way
     */

    private SendingHelper() {// empty
}

    /**
     * getSentDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getSentDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
        return value;
}

    /**
     * setSentDate :
     * @param wikitty 
     * @param sentDate 
     * @return Date 
     */

    public static Date setSentDate(Wikitty wikitty, Date sentDate) {
        Date oldValue = getSentDate(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE, sentDate);
        return oldValue;
}

    /**
     * getReceptionDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getReceptionDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
        return value;
}

    /**
     * setReceptionDate :
     * @param wikitty 
     * @param receptionDate 
     * @return Date 
     */

    public static Date setReceptionDate(Wikitty wikitty, Date receptionDate) {
        Date oldValue = getReceptionDate(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE, receptionDate);
        return oldValue;
}

    /**
     * getParagraph :
     * @param wikitty 
     * @return String 
     */

    public static String getParagraph(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
        return value;
}

    /**
     * setParagraph :
     * @param wikitty 
     * @param paragraph 
     * @return String 
     */

    public static String setParagraph(Wikitty wikitty, String paragraph) {
        String oldValue = getParagraph(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH, paragraph);
        return oldValue;
}

    /**
     * getReceptionProof :
     * @param wikitty 
     * @return boolean 
     */

    public static boolean getReceptionProof(Wikitty wikitty) {
        boolean value = wikitty.getFieldAsBoolean(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
        return value;
}

    /**
     * setReceptionProof :
     * @param wikitty 
     * @param receptionProof 
     * @return boolean 
     */

    public static boolean setReceptionProof(Wikitty wikitty, boolean receptionProof) {
        boolean oldValue = getReceptionProof(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF, receptionProof);
        return oldValue;
}

    /**
     * getStatus :
     * @param wikitty 
     * @return int 
     */

    public static int getStatus(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS);
        return value;
}

    /**
     * setStatus :
     * @param wikitty 
     * @param status 
     * @return int 
     */

    public static int setStatus(Wikitty wikitty, int status) {
        int oldValue = getStatus(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS, status);
        return oldValue;
}

    /**
     * getMessageId :
     * @param wikitty 
     * @return String 
     */

    public static String getMessageId(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
        return value;
}

    /**
     * setMessageId :
     * @param wikitty 
     * @param messageId 
     * @return String 
     */

    public static String setMessageId(Wikitty wikitty, String messageId) {
        String oldValue = getMessageId(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID, messageId);
        return oldValue;
}

    /**
     * getUser :
     * @param wikitty 
     * @return String 
     */

    public static String getUser(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER);
        return value;
}

    /**
     * setUser :
     * @param wikitty 
     * @param user 
     * @return String 
     */

    public static String setUser(Wikitty wikitty, String user) {
        String oldValue = getUser(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER, user);
        return oldValue;
}

    /**
     * getDeletedGroupForms :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getDeletedGroupForms(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDGROUPFORMS, String.class);
        return result;
}

    /**
     * setDeletedGroupForms :
     * @param wikitty 
     * @param deletedGroupForms 
     */

    public static void setDeletedGroupForms(Wikitty wikitty, Set<String> deletedGroupForms) {
        clearDeletedGroupForms(wikitty);
        addAllDeletedGroupForms(wikitty, deletedGroupForms);
}

    /**
     * addAllDeletedGroupForms :
     * @param wikitty 
     * @param deletedGroupForms 
     */

    public static void addAllDeletedGroupForms(Wikitty wikitty, Set<String> deletedGroupForms) {
        if(deletedGroupForms != null){
            for (String id:deletedGroupForms){
                addDeletedGroupForms(wikitty, id);
            }
        }
}

    /**
     * addDeletedGroupForms :
     * @param wikitty 
     * @param element 
     */

    public static void addDeletedGroupForms(Wikitty wikitty, String element) {
        wikitty.addToField(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDGROUPFORMS, element);
}

    /**
     * removeDeletedGroupForms :
     * @param wikitty 
     * @param element 
     */

    public static void removeDeletedGroupForms(Wikitty wikitty, String element) {
        wikitty.removeFromField(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDGROUPFORMS, element);
}

    /**
     * clearDeletedGroupForms :
     * @param wikitty 
     */

    public static void clearDeletedGroupForms(Wikitty wikitty) {
        wikitty.clearField(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDGROUPFORMS);
}

    /**
     * getAddedGroupForms :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAddedGroupForms(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Sending.EXT_SENDING, Sending.FIELD_SENDING_ADDEDGROUPFORMS, String.class);
        return result;
}

    /**
     * setAddedGroupForms :
     * @param wikitty 
     * @param addedGroupForms 
     */

    public static void setAddedGroupForms(Wikitty wikitty, Set<String> addedGroupForms) {
        clearAddedGroupForms(wikitty);
        addAllAddedGroupForms(wikitty, addedGroupForms);
}

    /**
     * addAllAddedGroupForms :
     * @param wikitty 
     * @param addedGroupForms 
     */

    public static void addAllAddedGroupForms(Wikitty wikitty, Set<String> addedGroupForms) {
        if(addedGroupForms != null){
            for (String id:addedGroupForms){
                addAddedGroupForms(wikitty, id);
            }
        }
}

    /**
     * addAddedGroupForms :
     * @param wikitty 
     * @param element 
     */

    public static void addAddedGroupForms(Wikitty wikitty, String element) {
        wikitty.addToField(Sending.EXT_SENDING, Sending.FIELD_SENDING_ADDEDGROUPFORMS, element);
}

    /**
     * removeAddedGroupForms :
     * @param wikitty 
     * @param element 
     */

    public static void removeAddedGroupForms(Wikitty wikitty, String element) {
        wikitty.removeFromField(Sending.EXT_SENDING, Sending.FIELD_SENDING_ADDEDGROUPFORMS, element);
}

    /**
     * clearAddedGroupForms :
     * @param wikitty 
     */

    public static void clearAddedGroupForms(Wikitty wikitty) {
        wikitty.clearField(Sending.EXT_SENDING, Sending.FIELD_SENDING_ADDEDGROUPFORMS);
}

    /**
     * getGroupForms :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getGroupForms(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Sending.EXT_SENDING, Sending.FIELD_SENDING_GROUPFORMS, String.class);
        return result;
}

    /**
     * setGroupForms :
     * @param wikitty 
     * @param groupForms 
     */

    public static void setGroupForms(Wikitty wikitty, Set<String> groupForms) {
        clearGroupForms(wikitty);
        addAllGroupForms(wikitty, groupForms);
}

    /**
     * addAllGroupForms :
     * @param wikitty 
     * @param groupForms 
     */

    public static void addAllGroupForms(Wikitty wikitty, Set<String> groupForms) {
        if(groupForms != null){
            for (String id:groupForms){
                addGroupForms(wikitty, id);
            }
        }
}

    /**
     * addGroupForms :
     * @param wikitty 
     * @param element 
     */

    public static void addGroupForms(Wikitty wikitty, String element) {
        wikitty.addToField(Sending.EXT_SENDING, Sending.FIELD_SENDING_GROUPFORMS, element);
}

    /**
     * removeGroupForms :
     * @param wikitty 
     * @param element 
     */

    public static void removeGroupForms(Wikitty wikitty, String element) {
        wikitty.removeFromField(Sending.EXT_SENDING, Sending.FIELD_SENDING_GROUPFORMS, element);
}

    /**
     * clearGroupForms :
     * @param wikitty 
     */

    public static void clearGroupForms(Wikitty wikitty) {
        wikitty.clearField(Sending.EXT_SENDING, Sending.FIELD_SENDING_GROUPFORMS);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDGROUPFORMS);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDGROUPFORMS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_ADDEDGROUPFORMS);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_ADDEDGROUPFORMS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_GROUPFORMS);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_GROUPFORMS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Sending.EXT_SENDING);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : SendingAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //SendingHelper
