/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class QueryMakerHelper {

    /**
     * QueryMakerHelper :
     * utility class all provided methods are accessible the static way
     */

    private QueryMakerHelper() {// empty
}

    /**
     * getQueries :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getQueries(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(QueryMaker.EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
}

    /**
     * setQueries :
     * @param wikitty 
     * @param queries 
     */

    public static void setQueries(Wikitty wikitty, Set<String> queries) {
        clearQueries(wikitty);
        addAllQueries(wikitty, queries);
}

    /**
     * addAllQueries :
     * @param wikitty 
     * @param queries 
     */

    public static void addAllQueries(Wikitty wikitty, Set<String> queries) {
        if(queries != null){
            for (String id:queries){
                addQueries(wikitty, id);
            }
        }
}

    /**
     * addQueries :
     * @param wikitty 
     * @param element 
     */

    public static void addQueries(Wikitty wikitty, String element) {
        wikitty.addToField(QueryMaker.EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
}

    /**
     * removeQueries :
     * @param wikitty 
     * @param element 
     */

    public static void removeQueries(Wikitty wikitty, String element) {
        wikitty.removeFromField(QueryMaker.EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES, element);
}

    /**
     * clearQueries :
     * @param wikitty 
     */

    public static void clearQueries(Wikitty wikitty) {
        wikitty.clearField(QueryMaker.EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(QueryMaker.EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES);
            Object f2 = w2.getFieldAsObject(QueryMaker.EXT_QUERYMAKER, QueryMaker.FIELD_QUERYMAKER_QUERIES);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(QueryMaker.EXT_QUERYMAKER);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : QueryMakerAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //QueryMakerHelper
