/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import javafx.util.StringConverter;
import jidefx.scene.control.field.verifier.RangePatternVerifier;
import jidefx.utils.CommonUtils;

public class NumberRangePatternVerifier
extends RangePatternVerifier<Number> {
    protected double adjustmentMultiplier = 1.0;

    public NumberRangePatternVerifier(Number min, Number max) {
        super(min, max);
    }

    public NumberRangePatternVerifier(Number min, Number max, double adjustmentMultiplier) {
        super(min, max);
        this.adjustmentMultiplier = adjustmentMultiplier;
    }

    protected double getAdjustment(double adjustment) {
        return this.adjustmentMultiplier * adjustment;
    }

    protected Number getDefaultValue() {
        return null;
    }

    @Override
    public String format(Number value) {
        StringConverter converter = this.getStringConverter();
        if (converter != null) {
            return converter.toString((Object)value);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public Number parse(String text) {
        StringConverter converter = this.getStringConverter();
        if (converter != null) {
            return (Number)converter.fromString(text);
        }
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        return Double.valueOf(text);
    }

    protected Number getGroupValue(double targetValue) {
        return targetValue;
    }

    protected double getTargetValue(Number groupValue) {
        return groupValue.doubleValue();
    }

    protected double getInitialValue(Number groupValue) {
        if (groupValue != null) {
            return groupValue.doubleValue();
        }
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue().doubleValue();
        }
        return 0.0;
    }

    protected Number ensureLessThanMax(Number groupValue) {
        if (groupValue.doubleValue() > ((Number)this.getMax()).doubleValue()) {
            groupValue = ((Number)this.getMax()).doubleValue();
        }
        return groupValue;
    }

    protected Number ensureMoreThanMin(Number groupValue) {
        if (groupValue.doubleValue() < ((Number)this.getMin()).doubleValue()) {
            groupValue = ((Number)this.getMin()).doubleValue();
        }
        return groupValue;
    }

    @Override
    public Number getNextValue(Number current, boolean restart) {
        double newValue = this.getInitialValue(current);
        double value = newValue + this.getAdjustment(1.0);
        return this.ensureLessThanMax(this.getGroupValue(value));
    }

    @Override
    public Number getPreviousValue(Number current, boolean restart) {
        double newValue = this.getInitialValue(current);
        double value = newValue + this.getAdjustment(-1.0);
        return this.ensureMoreThanMin(this.getGroupValue(value));
    }

    @Override
    public Number getNextPage(Number current, boolean restart) {
        double newValue = this.getInitialValue(current);
        double value = newValue + this.getAdjustment(10.0);
        return this.ensureLessThanMax(this.getGroupValue(value));
    }

    @Override
    public Number getPreviousPage(Number current, boolean restart) {
        double newValue = this.getInitialValue(current);
        double value = newValue + this.getAdjustment(-10.0);
        return this.ensureMoreThanMin(this.getGroupValue(value));
    }

    @Override
    public Number getHome(Number current) {
        return this.ensureMoreThanMin(((Number)this.getMin()).doubleValue());
    }

    @Override
    public Number getEnd(Number current) {
        return this.ensureMoreThanMin(((Number)this.getMax()).doubleValue());
    }

    public Boolean call(String text) {
        if (text.length() > this.getMaxLength()) {
            return false;
        }
        try {
            Number i = this.parse(text);
            if (i.doubleValue() >= ((Number)this.getMin()).doubleValue() && i.doubleValue() <= ((Number)this.getMax()).doubleValue()) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            CommonUtils.ignoreException((Exception)e);
        }
        catch (RuntimeException e) {
            CommonUtils.ignoreException((Exception)e);
        }
        return false;
    }
}

