/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import jidefx.scene.control.field.verifier.PatternVerifier;
import jidefx.scene.control.field.verifier.TemporalPatternVerifier;
import jidefx.utils.CommonUtils;

public class IntegerTemporalPatternVerifier
extends TemporalPatternVerifier
implements PatternVerifier.Length,
PatternVerifier.Formatter<Integer>,
PatternVerifier.Parser<Integer>,
PatternVerifier.Value<Temporal, Integer>,
PatternVerifier.Adjustable<Integer> {
    private boolean _fixedLength = false;
    private final DateTimeFormatter _formatter;

    public IntegerTemporalPatternVerifier(TemporalField field, TemporalUnit unit, String pattern) {
        this(field, unit, pattern, Integer.MIN_VALUE, Integer.MAX_VALUE, false);
    }

    public IntegerTemporalPatternVerifier(TemporalField field, TemporalUnit unit, String pattern, boolean fixedLength) {
        this(field, unit, pattern, Integer.MIN_VALUE, Integer.MAX_VALUE, fixedLength);
    }

    public IntegerTemporalPatternVerifier(TemporalField field, TemporalUnit unit, String pattern, long min, long max) {
        this(field, unit, pattern, min, max, false);
    }

    public IntegerTemporalPatternVerifier(TemporalField field, TemporalUnit unit, String pattern, long min, long max, boolean fixedLength) {
        super(field, unit, min, max);
        this._fixedLength = fixedLength;
        this._formatter = DateTimeFormatter.ofPattern(pattern).withResolverStyle(ResolverStyle.SMART);
    }

    @Override
    public Integer getEnd(Integer current) {
        if (this._value != null) {
            this._value = this._value.with(this._temporalField, this.getMax());
        }
        return null;
    }

    @Override
    public Integer getHome(Integer current) {
        if (this._value != null) {
            this._value = this._value.with(this._temporalField, this.getMin());
        }
        return null;
    }

    @Override
    public Integer getPreviousPage(Integer current, boolean restart) {
        if (this._value != null) {
            try {
                this._value = this._value.minus(10L, this._temporalUnit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Integer getNextPage(Integer current, boolean restart) {
        if (this._value != null) {
            try {
                this._value = this._value.plus(10L, this._temporalUnit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Integer getNextValue(Integer current, boolean restart) {
        if (this._value != null) {
            try {
                this._value = this._value.plus(1L, this._temporalUnit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Integer getPreviousValue(Integer current, boolean restart) {
        if (this._value != null) {
            try {
                this._value = this._value.minus(1L, this._temporalUnit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setFieldValue(Temporal fieldValue) {
        if (fieldValue != null) {
            this._value = fieldValue;
        }
    }

    @Override
    public Temporal getFieldValue() {
        return this._value;
    }

    @Override
    public Integer toTargetValue(Temporal fieldValue) {
        return fieldValue.get(this._temporalField);
    }

    @Override
    public Temporal fromTargetValue(Temporal existingValue, Integer value) {
        existingValue.with(this._temporalField, value.intValue());
        return existingValue;
    }

    @Override
    public int getMinLength() {
        return this._fixedLength ? this.getMaxLength() : 0;
    }

    @Override
    public int getMaxLength() {
        return this.format(this.getMax().intValue()).length();
    }

    @Override
    public String format(Integer value) {
        if (value == null) {
            return null;
        }
        return this._formatter.format(this.getFieldValue().with(this.getTemporalField(), value.intValue()));
    }

    @Override
    public Integer parse(String text) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        return this._formatter.parse(text).get(this.getTemporalField());
    }

    public Boolean call(String text) {
        if (text.length() > this.getMaxLength()) {
            return false;
        }
        try {
            long i = this.parse(text).intValue();
            if (i >= this.getMin() && i <= this.getMax()) {
                return true;
            }
        }
        catch (DateTimeParseException e) {
            CommonUtils.ignoreException((Exception)e);
        }
        return false;
    }
}

