/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.popup;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.popup.PopupContent;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.tbee.javafx.scene.layout.MigPane;

public abstract class ValuesPopupContent<S, T>
extends DecorationPane
implements PopupContent<S> {
    private List<FormattedTextField<T>> _fields;
    private static final String STYLE_CLASS_DEFAULT = "popup-content";
    private String[] _labels;
    private ObjectProperty<S> _valueProperty = null;

    public ValuesPopupContent(String[] labels) {
        super((Parent)new MigPane(new LC().minWidth("100px").insets("10 10 10 10"), new AC().align("right", new int[]{0}).size("pref", new int[]{0}).size("100px", new int[]{1}).fill(new int[]{1}).grow(1.0f).gap("10px"), new AC().gap("6px")));
        this.getStylesheets().add((Object)PopupContent.class.getResource("PopupContent.css").toExternalForm());
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
        this.initializeComponents(labels);
    }

    public abstract List<T> toValues(S var1);

    public abstract S fromValues(List<T> var1);

    public abstract FormattedTextField<T> createTextField(String var1);

    private void initializeComponents(String[] labels) {
        this._labels = labels;
        this._fields = new ArrayList<FormattedTextField<T>>();
        MigPane content = (MigPane)this.getContent();
        ChangeListener changeListener = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                Object value;
                List list = ValuesPopupContent.this.getValues();
                if (list.size() == ValuesPopupContent.this._fields.size() && (value = ValuesPopupContent.this.fromValues(list)) != null) {
                    ValuesPopupContent.this.setValue(value);
                }
            }
        };
        for (String text : labels) {
            Label label = new Label(text);
            content.add((Node)label);
            FormattedTextField<T> field = this.createTextField(text);
            field.valueProperty().addListener(changeListener);
            this._fields.add(field);
            field.installAdjustmentMouseHandler((Node)label);
            content.add(field, new CC().wrap());
        }
    }

    protected int getFieldIndex(String label) {
        for (int i = 0; i < this._labels.length; ++i) {
            if (!this._labels[i].equals(label)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final ObjectProperty<S> valueProperty() {
        if (this._valueProperty == null) {
            this._valueProperty = new SimpleObjectProperty<S>(this, "value"){

                protected void invalidated() {
                    super.invalidated();
                    ValuesPopupContent.this.updateFields(this.get());
                }
            };
        }
        return this._valueProperty;
    }

    @Override
    public final S getValue() {
        return (S)this.valueProperty().get();
    }

    @Override
    public final void setValue(S value) {
        this.valueProperty().set(value);
    }

    protected void updateFields(S value) {
        List<T> values = this.toValues(value);
        if (values.size() != this._fields.size()) {
            throw new IllegalStateException("The number of the values return from toValues method must be the same as the number of labels passed in to ValuePopupContent's constructor.");
        }
        for (int i = 0; i < this._fields.size(); ++i) {
            this._fields.get(i).setValue(values.get(i));
        }
    }

    protected List<T> getValues() {
        ArrayList<T> values = new ArrayList<T>();
        for (FormattedTextField<T> field : this._fields) {
            T value = field.getValue();
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }
}

