/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.popup;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Callback;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.field.NumberField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.PopupsResource;
import jidefx.scene.control.searchable.ComboBoxSearchable;
import jidefx.utils.FXUtils;
import jidefx.utils.FontUtils;
import jidefx.utils.LazyLoadUtils;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.tbee.javafx.scene.layout.MigPane;

public class FontPopupContent
extends DecorationPane
implements PopupContent<Font> {
    private static final String STYLE_CLASS_DEFAULT = "popup-content";
    private ComboBox<String> _fontFamilyComboBox;
    private NumberField _sizeSpinner;
    private ChoiceBox<String> _styleChoiceBox;
    private Label _previewLabel;

    public FontPopupContent(Font font) {
        super((Parent)new MigPane(new LC().maxWidth("230px").maxHeight("180px").insets("10 10 10 10"), new AC().align("right", new int[]{0}).size("160px", new int[]{1}).fill(new int[]{1}).grow(1.0f).gap("10px"), new AC().gap("6px")));
        this.getStylesheets().add((Object)PopupContent.class.getResource("PopupContent.css").toExternalForm());
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
        this.initializeComponents(font == null ? Font.getDefault() : font);
        this.installListeners();
        this.updateValues();
    }

    private void initializeComponents(Font font) {
        BorderPane previewPanel = new BorderPane();
        previewPanel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.0))}));
        this._previewLabel = new Label(this.getResourceString("preview"));
        this._previewLabel.setPrefSize(210.0, 60.0);
        this._previewLabel.setAlignment(Pos.CENTER);
        this._previewLabel.setFont(font);
        previewPanel.setCenter((Node)this._previewLabel);
        this._fontFamilyComboBox = new ComboBox();
        LazyLoadUtils.install(this._fontFamilyComboBox, (Callback)new Callback<ComboBox<String>, ObservableList<String>>(){

            public ObservableList<String> call(ComboBox<String> comboBox) {
                return FXCollections.observableArrayList((Collection)Font.getFamilies());
            }
        });
        this._fontFamilyComboBox.setPrefWidth(160.0);
        new ComboBoxSearchable(this._fontFamilyComboBox);
        DecimalFormat integerFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
        integerFormat.setMaximumIntegerDigits(3);
        integerFormat.setMaximumFractionDigits(1);
        this._sizeSpinner = new NumberField();
        this._sizeSpinner.setDecimalFormat(integerFormat);
        this._sizeSpinner.setSpinnersVisible(true);
        this._sizeSpinner.setValue(font.getSize());
        this._styleChoiceBox = new ChoiceBox();
        MigPane content = (MigPane)this.getContent();
        content.add((Node)previewPanel, new CC().grow().span(new int[]{2}).wrap().gapBottom("6px"));
        content.add((Node)new Label(this.getResourceString("font")));
        content.add(this._fontFamilyComboBox, new CC().wrap());
        Label sizeLabel = new Label(this.getResourceString("size"));
        content.add((Node)sizeLabel);
        content.add((Node)this._sizeSpinner, new CC().split().maxWidth("60px").wrap());
        this._sizeSpinner.installAdjustmentMouseHandler((Node)sizeLabel);
        content.add((Node)new Label(this.getResourceString("style")));
        content.add(this._styleChoiceBox, new CC().grow().wrap());
    }

    private void updateValues() {
        Font font = this.getValue();
        this._fontFamilyComboBox.setValue((Object)font.getFamily());
        this._styleChoiceBox.setValue((Object)font.getStyle());
    }

    private void installListeners() {
        this._fontFamilyComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FontPopupContent.this.updateStyleChoiceBox();
            }
        });
        this._sizeSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                FontPopupContent.this.updateStyleChoiceBox();
            }
        });
        this._styleChoiceBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FontPopupContent.this._previewLabel.setFont(FontUtils.createFont((String)((String)FontPopupContent.this._fontFamilyComboBox.getValue()), (String)newValue, (double)((Number)FontPopupContent.this._sizeSpinner.getValue()).doubleValue()));
            }
        });
    }

    private void updateStyleChoiceBox() {
        LazyLoadUtils.install(this._styleChoiceBox, (Callback)new Callback<ChoiceBox<String>, ObservableList<String>>(){

            public ObservableList<String> call(final ChoiceBox<String> comboBox) {
                final List supportedFontStyle = FontUtils.getSupportedFontStyles((String)((String)FontPopupContent.this._fontFamilyComboBox.getValue()), (double)((Number)FontPopupContent.this._sizeSpinner.getValue()).doubleValue());
                FXUtils.runThreadSafe((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        comboBox.setDisable(supportedFontStyle.size() <= 1);
                    }
                });
                return FXCollections.observableArrayList((Collection)supportedFontStyle);
            }
        });
    }

    @Override
    public final Font getValue() {
        return this._previewLabel.getFont();
    }

    @Override
    public final void setValue(Font value) {
        this._previewLabel.setFont(value);
    }

    @Override
    public final ObjectProperty<Font> valueProperty() {
        return this._previewLabel.fontProperty();
    }

    public String getResourceString(String key) {
        if (key == null) {
            return "";
        }
        return PopupsResource.getResourceBundle(Locale.getDefault()).getString(key);
    }
}

