/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Rectangle2D;
import javafx.util.Callback;
import jidefx.scene.control.field.DoubleField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.ValuesPopupContent;
import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.javafx.Rectangle2DConverter;

public class Rectangle2DField
extends PopupField<Rectangle2D> {
    private static final String STYLE_CLASS_DEFAULT = "rectangle-2d-field";

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new Rectangle2DConverter(){

            protected String toString(int i, Double o, ConverterContext context) {
                if (o == null) {
                    return "";
                }
                return o.toString();
            }

            protected Double fromString(int i, String s, ConverterContext context) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                return Double.valueOf(s);
            }
        }.toStringConverter());
        this.getPatternVerifiers().put((Object)"X", (Object)new NumberValuePatternVerifier<Rectangle2D>(){

            @Override
            public Double toTargetValue(Rectangle2D fieldValue) {
                return fieldValue.getMinX();
            }

            @Override
            public Rectangle2D fromTargetValue(Rectangle2D previousFieldValue, Number value) {
                double x = value.doubleValue();
                return previousFieldValue != null ? new Rectangle2D(x, previousFieldValue.getMinY(), previousFieldValue.getWidth(), previousFieldValue.getHeight()) : new Rectangle2D(x, 0.0, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Y", (Object)new NumberValuePatternVerifier<Rectangle2D>(){

            @Override
            public Double toTargetValue(Rectangle2D fieldValue) {
                return fieldValue.getMinY();
            }

            @Override
            public Rectangle2D fromTargetValue(Rectangle2D previousFieldValue, Number value) {
                double y = value.doubleValue();
                return previousFieldValue != null ? new Rectangle2D(previousFieldValue.getMinX(), y, previousFieldValue.getWidth(), previousFieldValue.getHeight()) : new Rectangle2D(0.0, y, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Width", (Object)new NumberValuePatternVerifier<Rectangle2D>((Number)0, (Number)Double.MAX_VALUE){

            @Override
            public Double toTargetValue(Rectangle2D fieldValue) {
                return fieldValue.getWidth();
            }

            @Override
            public Rectangle2D fromTargetValue(Rectangle2D previousFieldValue, Number value) {
                double width = value.doubleValue();
                return previousFieldValue != null ? new Rectangle2D(previousFieldValue.getMinX(), previousFieldValue.getMinY(), width, previousFieldValue.getHeight()) : new Rectangle2D(0.0, 0.0, width, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Height", (Object)new NumberValuePatternVerifier<Rectangle2D>((Number)0, (Number)Double.MAX_VALUE){

            @Override
            public Double toTargetValue(Rectangle2D fieldValue) {
                return fieldValue.getHeight();
            }

            @Override
            public Rectangle2D fromTargetValue(Rectangle2D previousFieldValue, Number value) {
                double height = value.doubleValue();
                return previousFieldValue != null ? new Rectangle2D(previousFieldValue.getMinX(), previousFieldValue.getMinY(), previousFieldValue.getWidth(), height) : new Rectangle2D(0.0, 0.0, 0.0, height);
            }
        });
        this.setPattern("X; Y; Width; Height");
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Rectangle2D, PopupContent<Rectangle2D>>(){

            public PopupContent<Rectangle2D> call(Rectangle2D param) {
                ValuesPopupContent<Rectangle2D, Double> popupContent = new ValuesPopupContent<Rectangle2D, Double>(new String[]{Rectangle2DField.this.getResourceString("x"), Rectangle2DField.this.getResourceString("y"), Rectangle2DField.this.getResourceString("width"), Rectangle2DField.this.getResourceString("height")}){

                    @Override
                    public List<Double> toValues(Rectangle2D value) {
                        ArrayList<Double> list = new ArrayList<Double>(4);
                        list.add(value.getMinX());
                        list.add(value.getMinY());
                        list.add(value.getWidth());
                        list.add(value.getHeight());
                        return list;
                    }

                    @Override
                    public Rectangle2D fromValues(List<Double> values) {
                        return new Rectangle2D(values.get(0).doubleValue(), values.get(1).doubleValue(), values.get(2).doubleValue(), values.get(3).doubleValue());
                    }

                    @Override
                    public FormattedTextField<Double> createTextField(String label) {
                        int fieldIndex = this.getFieldIndex(label);
                        if (fieldIndex == 2 || fieldIndex == 3) {
                            return new DoubleField(0.0, Double.MAX_VALUE);
                        }
                        return new DoubleField();
                    }
                };
                popupContent.setValue((Rectangle2D)Rectangle2DField.this.getValue());
                return popupContent;
            }
        });
    }
}

