/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.util.Callback;
import jidefx.scene.control.field.DoubleField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.ValuesPopupContent;
import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.javafx.Point2DConverter;

public class Point2DField
extends PopupField<Point2D> {
    private static final String STYLE_CLASS_DEFAULT = "point-2d-field";

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new Point2DConverter(){

            protected String toString(int i, Double o, ConverterContext context) {
                if (o == null) {
                    return "";
                }
                return o.toString();
            }

            protected Double fromString(int i, String s, ConverterContext context) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                return Double.valueOf(s);
            }
        }.toStringConverter());
        this.getPatternVerifiers().put((Object)"X", (Object)new NumberValuePatternVerifier<Point2D>(){

            @Override
            public Double toTargetValue(Point2D fieldValue) {
                return fieldValue.getX();
            }

            @Override
            public Point2D fromTargetValue(Point2D previousFieldValue, Number value) {
                double x = value.doubleValue();
                return previousFieldValue != null ? new Point2D(x, previousFieldValue.getY()) : new Point2D(x, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Y", (Object)new NumberValuePatternVerifier<Point2D>(){

            @Override
            public Double toTargetValue(Point2D fieldValue) {
                return fieldValue.getY();
            }

            @Override
            public Point2D fromTargetValue(Point2D previousFieldValue, Number value) {
                double y = value.doubleValue();
                return previousFieldValue != null ? new Point2D(previousFieldValue.getX(), y) : new Point2D(0.0, y);
            }
        });
        this.setPattern("X; Y");
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Point2D, PopupContent<Point2D>>(){

            public PopupContent<Point2D> call(Point2D param) {
                ValuesPopupContent<Point2D, Double> popupContent = new ValuesPopupContent<Point2D, Double>(new String[]{"X: ", "Y: "}){

                    @Override
                    public List<Double> toValues(Point2D value) {
                        ArrayList<Double> list = new ArrayList<Double>(2);
                        list.add(value.getX());
                        list.add(value.getY());
                        return list;
                    }

                    @Override
                    public Point2D fromValues(List<Double> values) {
                        return new Point2D(values.get(0).doubleValue(), values.get(1).doubleValue());
                    }

                    @Override
                    public FormattedTextField<Double> createTextField(String label) {
                        return new DoubleField();
                    }
                };
                popupContent.setValue((Point2D)Point2DField.this.getValue());
                return popupContent;
            }
        });
    }
}

