/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.editor;

import com.jidefx.utils.CacheMap;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Supplier;
import javafx.geometry.BoundingBox;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import jidefx.scene.control.combobox.BoundingBoxComboBox;
import jidefx.scene.control.combobox.Dimension2DComboBox;
import jidefx.scene.control.combobox.InsetsComboBox;
import jidefx.scene.control.combobox.IntegerComboBox;
import jidefx.scene.control.combobox.Point2DComboBox;
import jidefx.scene.control.combobox.Point3DComboBox;
import jidefx.scene.control.combobox.Rectangle2DComboBox;
import jidefx.scene.control.editor.CheckBoxEditor;
import jidefx.scene.control.editor.Editor;
import jidefx.scene.control.editor.EditorContext;
import jidefx.scene.control.editor.EnumChoiceBoxEditor;
import jidefx.scene.control.editor.EnumComboBoxEditor;
import jidefx.scene.control.editor.LazyInitializeEditor;
import jidefx.scene.control.editor.TextFieldEditor;
import jidefx.scene.control.field.BoundingBoxField;
import jidefx.scene.control.field.CalendarField;
import jidefx.scene.control.field.ColorField;
import jidefx.scene.control.field.DateField;
import jidefx.scene.control.field.Dimension2DField;
import jidefx.scene.control.field.FontField;
import jidefx.scene.control.field.InsetsField;
import jidefx.scene.control.field.IntegerField;
import jidefx.scene.control.field.LocalDateField;
import jidefx.scene.control.field.LocalDateTimeField;
import jidefx.scene.control.field.LocalTimeField;
import jidefx.scene.control.field.NumberField;
import jidefx.scene.control.field.Point2DField;
import jidefx.scene.control.field.Point3DField;
import jidefx.scene.control.field.Rectangle2DField;

public class EditorManager {
    public static final String PROPERTY_EDITOR_MANAGER = "EditorManager";
    private static EditorManager _instance = EditorManager.createInstance();
    private boolean _inited = false;
    private boolean _initing = false;
    private boolean _autoInit = true;
    private CacheMap<Object, EditorContext> _cache = new CacheMap((Object)EditorContext.CONTEXT_DEFAULT);
    private Supplier<Editor> _defaultEditorSupplier = new Supplier<Editor>(){

        @Override
        public Editor get() {
            return new TextFieldEditor();
        }
    };

    public static EditorManager createInstance() {
        return new EditorManager();
    }

    public static EditorManager getInstance() {
        return _instance;
    }

    public static EditorManager getInstance(Node node) {
        if (node != null && node.getProperties().get((Object)PROPERTY_EDITOR_MANAGER) instanceof EditorManager) {
            return (EditorManager)node.getProperties().get((Object)PROPERTY_EDITOR_MANAGER);
        }
        return EditorManager.getInstance();
    }

    public void registerEditor(Class<?> clazz, Supplier<Editor> editorFactory, EditorContext context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (context == null) {
            context = EditorContext.CONTEXT_DEFAULT;
        }
        if (this.isAutoInit() && !this._inited && !this._initing) {
            this.initDefaultEditors();
        }
        this._cache.register(clazz, editorFactory, (Object)context);
    }

    public void registerEditor(Class<?> clazz, Supplier<Editor> editorFactory) {
        this.registerEditor(clazz, editorFactory, EditorContext.CONTEXT_DEFAULT);
    }

    public void unregisterEditor(Class<?> clazz, EditorContext context) {
        if (context == null) {
            context = EditorContext.CONTEXT_DEFAULT;
        }
        if (this.isAutoInit() && !this._inited && !this._initing) {
            this.initDefaultEditors();
        }
        this._cache.unregister(clazz, (Object)context);
    }

    public void unregisterAllEditors(Class<?> clazz) {
        this._cache.remove(clazz);
    }

    public void unregisterAllEditors() {
        this._cache.clear();
    }

    public Editor getEditor(Class<?> clazz, EditorContext context) {
        Object object;
        Editor editor;
        if (this.isAutoInit() && !this._inited && !this._initing) {
            this.initDefaultEditors();
        }
        if (context == null) {
            context = EditorContext.CONTEXT_DEFAULT;
        }
        if ((editor = (object = this._cache.getRegisteredObject(clazz, (Object)context)) != null && object instanceof Supplier ? (Editor)((Supplier)object).get() : (object != null && object instanceof Editor ? (Editor)object : (context.equals(EditorContext.CONTEXT_DEFAULT) ? this._defaultEditorSupplier.get() : this.getEditor(clazz, EditorContext.CONTEXT_DEFAULT)))) instanceof LazyInitializeEditor) {
            ((LazyInitializeEditor)((Object)editor)).initialize(clazz, context);
        }
        return editor;
    }

    public Editor getEditor(Class<?> clazz) {
        return this.getEditor(clazz, EditorContext.CONTEXT_DEFAULT);
    }

    public boolean isAutoInit() {
        return this._autoInit;
    }

    public void setAutoInit(boolean autoInit) {
        this._autoInit = autoInit;
    }

    public EditorContext[] getEditorContexts(Class<?> clazz) {
        return (EditorContext[])this._cache.getKeys(clazz, (Object[])new EditorContext[0]);
    }

    public void initDefaultEditors() {
        if (this._inited) {
            return;
        }
        this._initing = true;
        try {
            this.registerEditor(Color.class, () -> new ColorField());
            this.registerEditor(Color.class, () -> new ColorField(ColorField.ColorFormat.RGB), new EditorContext(ColorField.ColorFormat.RGB.name()));
            this.registerEditor(Color.class, () -> new ColorField(ColorField.ColorFormat.HEX_RGB), new EditorContext(ColorField.ColorFormat.HEX_RGB.name()));
            this.registerEditor(Color.class, () -> new ColorField(ColorField.ColorFormat.RGBA), new EditorContext(ColorField.ColorFormat.RGBA.name()));
            this.registerEditor(Color.class, () -> new ColorField(ColorField.ColorFormat.HEX_RGBA), new EditorContext(ColorField.ColorFormat.HEX_RGBA.name()));
            this.registerEditor(Integer.class, () -> new IntegerField());
            this.registerEditor(Integer.class, () -> new IntegerComboBox(), new EditorContext("ComboBox"));
            this.registerEditor(Double.class, () -> new NumberField(NumberField.NumberType.Currency), new EditorContext("Currency"));
            this.registerEditor(Double.class, () -> new NumberField(NumberField.NumberType.Percent), new EditorContext("Percent"));
            this.registerEditor(Date.class, () -> new DateField());
            this.registerEditor(Calendar.class, () -> new CalendarField());
            this.registerEditor(LocalDate.class, () -> new LocalDateField());
            this.registerEditor(LocalDateTime.class, () -> new LocalDateTimeField());
            this.registerEditor(LocalTime.class, () -> new LocalTimeField());
            this.registerEditor(Enum.class, () -> new EnumChoiceBoxEditor());
            this.registerEditor(Enum.class, () -> new EnumComboBoxEditor(), new EditorContext("ComboBox"));
            this.registerEditor(Boolean.class, () -> new CheckBoxEditor());
            this.registerEditor(Point2D.class, () -> new Point2DField());
            this.registerEditor(Point2D.class, () -> new Point2DComboBox(), new EditorContext("ComboBox"));
            this.registerEditor(Point3D.class, () -> new Point3DField());
            this.registerEditor(Point3D.class, () -> new Point3DComboBox(), new EditorContext("ComboBox"));
            this.registerEditor(Dimension2D.class, () -> new Dimension2DField());
            this.registerEditor(Dimension2D.class, () -> new Dimension2DComboBox(), new EditorContext("ComboBox"));
            this.registerEditor(BoundingBox.class, () -> new BoundingBoxField());
            this.registerEditor(BoundingBox.class, () -> new BoundingBoxComboBox(), new EditorContext("ComboBox"));
            this.registerEditor(Insets.class, () -> new InsetsField());
            this.registerEditor(Insets.class, () -> new InsetsComboBox(), new EditorContext("ComboBox"));
            this.registerEditor(Rectangle2D.class, () -> new Rectangle2DField());
            this.registerEditor(Rectangle2D.class, () -> new Rectangle2DComboBox(), new EditorContext("ComboBox"));
            this.registerEditor(Font.class, () -> new FontField());
        }
        finally {
            this._initing = false;
            this._inited = true;
        }
    }

    public void resetInit() {
        this._inited = false;
    }

    public void clear() {
        this.resetInit();
        this._cache.clear();
    }
}

