/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.combobox;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;
import jidefx.scene.control.combobox.FormattedComboBox;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.LocalDateTimeField;
import jidefx.scene.control.field.popup.PopupContent;

public class LocalDateTimeComboBox
extends FormattedComboBox<LocalDateTime> {
    private static final String STYLE_CLASS_DEFAULT = "local-date-time-combo-box";
    private StringProperty _patternProperty;

    public LocalDateTimeComboBox() {
        this(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance()).toPattern(), LocalDateTime.now());
    }

    public LocalDateTimeComboBox(String pattern) {
        this(pattern, LocalDateTime.now());
    }

    public LocalDateTimeComboBox(LocalDateTime value) {
        this(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance()).toPattern(), value);
    }

    public LocalDateTimeComboBox(String pattern, LocalDateTime value) {
        super(value);
        this.setPattern(pattern);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
    }

    public StringProperty patternProperty() {
        if (this._patternProperty == null) {
            this._patternProperty = new SimpleStringProperty();
        }
        return this._patternProperty;
    }

    public String getPattern() {
        return (String)this.patternProperty().get();
    }

    public void setPattern(String pattern) {
        this.patternProperty().set((Object)pattern);
    }

    @Override
    protected FormattedTextField<LocalDateTime> createFormattedTextField() {
        LocalDateTimeField field = new LocalDateTimeField(this.getPattern());
        field.patternProperty().bind((ObservableValue)this.patternProperty());
        return field;
    }

    @Override
    protected void initializeComboBox() {
        super.initializeComboBox();
        this.setPopupContentFactory(new Callback<LocalDateTime, PopupContent<LocalDateTime>>(){

            public PopupContent<LocalDateTime> call(LocalDateTime param) {
                PopupContent popupContent = (PopupContent)((LocalDateTimeField)LocalDateTimeComboBox.this.getEditor()).getPopupContentFactory().call((Object)param);
                popupContent.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDateTime>(){

                    public void changed(ObservableValue<? extends LocalDateTime> observable, LocalDateTime oldValue, LocalDateTime newValue) {
                        LocalDateTimeComboBox.this.hide();
                    }
                });
                return popupContent;
            }
        });
    }
}

